/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.io.InputStream;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.auoeke.reflect.Accessor;
import net.auoeke.reflect.Fields;
import net.auoeke.reflect.Invoker;
import net.auoeke.reflect.Pointer;
import net.auoeke.reflect.StackFrames;
import net.auoeke.result.Result;
import net.gudenau.lib.unsafe.Unsafe;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class Classes {
    public static final Class<?> ConstantPool = Classes.tryLoad("jdk.internal.reflect.ConstantPool", "sun.reflect.ConstantPool");
    public static final Class<?> JavaLangAccess = Classes.tryLoad("jdk.internal.access.JavaLangAccess", "jdk.internal.misc.JavaLangAccess", "sun.misc.JavaLangAccess");
    public static final Class<?> Reflection = Classes.tryLoad("jdk.internal.reflect.Reflection", "sun.reflect.Reflection");
    public static final Class<?> SharedSecrets = Classes.tryLoad("jdk.internal.access.SharedSecrets", "jdk.internal.misc.SharedSecrets", "sun.misc.SharedSecrets");
    public static final Class<?> URLClassPath = Classes.tryLoad("jdk.internal.loader.URLClassPath", "sun.misc.URLClassPath");
    public static final Object systemClassPath = Classes.classPath(ClassLoader.getSystemClassLoader());
    public static final Pointer klass;
    public static final Pointer firstField;

    public static <T> T reinterpret(Object object, T ... dummy) {
        return (T)Classes.reinterpret(Unsafe.allocateInstance(dummy.getClass().getComponentType()), object);
    }

    public static <T> T reinterpret(Object object, Class<T> type) {
        return (T)Classes.reinterpret(Unsafe.allocateInstance(type), object);
    }

    public static <T> T reinterpret(T source, Object object) {
        klass.copy(source, object);
        return (T)object;
    }

    public static <T> T reinterpret(Object object, long klass) {
        Classes.klass.put(object, klass);
        return (T)object;
    }

    public static long klass(Class<?> type) {
        return Classes.klass(Unsafe.allocateInstance(type));
    }

    public static long klass(Object object) {
        return klass.getAddress(object);
    }

    public static <T> T cast(Object object) {
        return (T)object;
    }

    public static <T> Class<T> findLoadedClass(ClassLoader loader, String klass) {
        return ( /* dynamic constant */ (Object)ConstantBootstraps.invoke("0", new Object[]{lambda$findLoadedClass$0()})).invokeExact(loader, klass);
    }

    public static URL[] urls(ClassLoader classLoader) {
        return Classes.urls(Classes.classPath(classLoader));
    }

    public static URL[] urls(Object classPath) {
        return ( /* dynamic constant */ (Object)ConstantBootstraps.invoke("1", new Object[]{lambda$urls$1()})).invoke(classPath);
    }

    public static void addSystemURL(URL ... url) {
        Classes.addURL(systemClassPath, url);
    }

    public static void addSystemURL(URL url) {
        Classes.addURL(systemClassPath, url);
    }

    public static void addURL(ClassLoader classLoader, URL ... urls) {
        Classes.addURL(Classes.classPath(classLoader), urls);
    }

    public static void addURL(ClassLoader classLoader, URL url) {
        Classes.addURL(Classes.classPath(classLoader), url);
    }

    public static void addURL(Object classPath, URL ... urls) {
        for (URL url : urls) {
            Classes.addURL(classPath, url);
        }
    }

    public static void addURL(Object classPath, URL url) {
        ( /* dynamic constant */ (Object)ConstantBootstraps.invoke("2", new Object[]{lambda$addURL$2()})).invoke(classPath, url);
    }

    public static Object classPath(ClassLoader classLoader) {
        return Accessor.getReference((Object)classLoader, Classes.classPathField(classLoader.getClass()));
    }

    public static Field classPathField(Class<?> loaderClass) {
        return Fields.allInstance(loaderClass).filter(field -> URLClassPath.isAssignableFrom(field.getType())).findAny().orElse(null);
    }

    public static <T> Class<T> load(ClassLoader loader, boolean initialize, String name) {
        return (Class)Result.of(() -> Class.forName(name, initialize, loader)).valueOrNull();
    }

    public static <T> Class<T> load(String name) {
        return Classes.load(StackFrames.caller().getClassLoader(), true, name);
    }

    public static <T> Class<T> load(boolean initialize, String name) {
        return Classes.load(StackFrames.caller().getClassLoader(), initialize, name);
    }

    public static <T> Class<T> load(ClassLoader loader, String name) {
        return Classes.load(loader, true, name);
    }

    public static <T> Class<T> loadWithCaller(String name) {
        return Classes.load(StackFrames.caller(2).getClassLoader(), name);
    }

    public static <T> Class<T> loadWithCaller(boolean initialize, String name) {
        return Classes.load(StackFrames.caller(2).getClassLoader(), initialize, name);
    }

    public static <T> Class<T> initialize(Class<T> type) {
        Unsafe.ensureClassInitialized(type);
        return type;
    }

    public static byte[] classFile(ClassLoader loader, String type) {
        type = ((String)type).replace('.', '/') + ".class";
        InputStream stream = loader == null ? Object.class.getResourceAsStream("/" + (String)type) : loader.getResourceAsStream((String)type);
        return stream == null ? null : Classes.read(stream);
    }

    public static byte[] classFile(String type) {
        return Classes.classFile(StackFrames.caller().getClassLoader(), type);
    }

    public static byte[] classFile(Class<?> type) {
        InputStream stream = Classes.checkUserDefined(type).getResourceAsStream("/" + Classes.path(type));
        return stream == null ? null : Classes.read(stream);
    }

    public static byte[] read(InputStream resource) {
        try (InputStream input = resource;){
            byte[] byArray = input.readAllBytes();
            return byArray;
        }
    }

    public static <T> Stream<T> stream(Enumeration<T> enumeration) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(enumeration.asIterator(), 256), false);
    }

    public static Stream<URL> resources(ClassLoader loader, String name) {
        return loader == null ? Classes.stream(( /* dynamic constant */ (Object)ConstantBootstraps.invoke("3", new Object[]{lambda$resources$5()})).invokeExact(name)) : loader.resources(name);
    }

    public static String internalName(Class<?> type) {
        return Classes.checkUserDefined(type).getName().replace('.', '/');
    }

    public static String localName(Class<?> type) {
        if (type.isArray()) {
            return "[" + Classes.localName(type.componentType());
        }
        String name = type.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static String path(Class<?> type) {
        return Classes.internalName(Classes.checkUserDefined(type)) + ".class";
    }

    public static String filename(Class<?> type) {
        return Classes.localName(Classes.checkUserDefined(type)) + ".class";
    }

    public static URL sourceResource(Class<?> anchor, String path) {
        Objects.requireNonNull(path, "path");
        URL anchorLocation = anchor.getResource(Classes.filename(anchor));
        if (anchorLocation == null) {
            return null;
        }
        String string = anchorLocation.toString();
        URL url = new URL(string.substring(0, string.lastIndexOf(Classes.path(anchor))) + path);
        return path.isEmpty() ? url : Classes.realURLOrNull(url);
    }

    public static URL findResource(Class<?> anchor, String path) {
        Objects.requireNonNull(path, "path");
        URL source = Classes.location(anchor);
        if (source == null) {
            return Classes.sourceResource(anchor, path);
        }
        boolean isJar = source.getPath().endsWith(".jar");
        URL url = !isJar && path.isEmpty() ? source : new URL(isJar ? "jar:" + String.valueOf(source) + "!/" + path : String.valueOf(source) + "/" + path);
        return path.isEmpty() ? url : Classes.realURLOrNull(url);
    }

    public static URL findSource(Class<?> type) {
        URL location = Classes.location(type);
        if (location != null) {
            return location;
        }
        location = type.getResource(Classes.filename(type));
        if (location == null) {
            return null;
        }
        String string = location.toString();
        string = string.substring(0, string.lastIndexOf(Classes.path(type)));
        return new URL("jar".equals(location.getProtocol()) && string.endsWith("!/") ? string.substring(4, string.length() - 2) : string);
    }

    public static URL findRoot(Class<?> type) {
        URL location = Classes.location(type);
        return location == null ? Classes.sourceResource(type, "") : (location.getPath().endsWith(".jar") ? new URL("jar:" + String.valueOf(location) + "!/") : location);
    }

    public static Path findRootPath(Class<?> type) {
        URL location = Classes.findRoot(type);
        if (location == null) {
            return null;
        }
        return (Path)Result.of(location::toURI).flatMap(root -> Result.of(() -> Path.of(root)).or(() -> FileSystems.newFileSystem(root, Map.of()).getPath("/", new String[0]))).value();
    }

    public static List<Type> genericSupertypes(Class<?> type) {
        ArrayList<Type> supertypes = new ArrayList<Type>(Arrays.asList(type.getGenericInterfaces()));
        Type superclass = type.getGenericSuperclass();
        if (superclass != null) {
            supertypes.add(superclass);
        }
        return supertypes;
    }

    public static URL location(Class<?> type) {
        ProtectionDomain domain = type.getProtectionDomain();
        if (domain == null) {
            return null;
        }
        CodeSource source = domain.getCodeSource();
        return source == null ? null : source.getLocation();
    }

    public static CodeSource codeSource(URL url) {
        Certificate[] certificateArray;
        URLConnection uRLConnection;
        if (url != null && (uRLConnection = url.openConnection()) instanceof JarURLConnection) {
            JarURLConnection jar = (JarURLConnection)uRLConnection;
            certificateArray = jar.getCertificates();
        } else {
            certificateArray = null;
        }
        return new CodeSource(url, certificateArray);
    }

    public static ProtectionDomain protectionDomain(URL url, ClassLoader loader) {
        return new ProtectionDomain(Classes.codeSource(url), null, loader, null);
    }

    private static Class<?> tryLoad(String ... classes) {
        return Stream.of(classes).map(Classes::load).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static Class<?> checkUserDefined(Class<?> type) {
        if (type.isPrimitive() || type.isArray()) {
            throw new IllegalArgumentException("type must be user-defined");
        }
        return type;
    }

    private static URL realURLOrNull(URL url) {
        return (URL)Result.success((Object)url).filter(u -> {
            URLConnection connection = u.openConnection();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection http = (HttpURLConnection)connection;
                http.setRequestMethod("HEAD");
                return http.getResponseCode() < 400;
            }
            connection.getInputStream();
            return true;
        }).valueOrNull();
    }

    private static /* synthetic */ MethodHandle lambda$resources$5() {
        return Invoker.findStatic(Class.forName("jdk.internal.loader.BootLoader"), "findResources", Enumeration.class, String.class);
    }

    private static /* synthetic */ MethodHandle lambda$addURL$2() {
        return Invoker.findVirtual(URLClassPath, "addURL", Void.TYPE, URL.class);
    }

    private static /* synthetic */ MethodHandle lambda$urls$1() {
        return Invoker.findVirtual(URLClassPath, "getURLs", URL[].class);
    }

    private static /* synthetic */ MethodHandle lambda$findLoadedClass$0() {
        return Invoker.findVirtual(ClassLoader.class, "findLoadedClass", Class.class, String.class);
    }

    static {
        firstField = Pointer.of(Fields.instanceOf(Integer.class).findAny().get());
        char[] charArray = new char[]{};
        short[] shortArray = new short[]{};
        long offset = 0L;
        while (Unsafe.getInt((Object)charArray, (long)offset) == Unsafe.getInt((Object)shortArray, (long)offset)) {
            offset += 4L;
        }
        klass = Pointer.of(offset, 9);
    }
}

