/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.util.stream.Stream;
import net.auoeke.reflect.AccessibleObjects;
import net.auoeke.reflect.Invoker;
import net.auoeke.reflect.Methods;
import net.auoeke.result.Result;
import net.gudenau.lib.unsafe.Unsafe;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class Constructors {
    public static <T> Stream<Constructor<T>> of(Class<T> type) {
        return Stream.of(type.getDeclaredConstructors());
    }

    public static <T> T instantiate(Class<T> type) {
        return (T)Result.of(() -> Invoker.findConstructor(type).invoke()).or(() -> Unsafe.allocateInstance((Class)type)).value();
    }

    public static <T> T construct(Class<T> type, Object ... arguments) {
        return (T)Invoker.unreflectConstructor(Constructors.find(type, arguments)).invokeWithArguments(arguments);
    }

    public static <T> Constructor<T> find(long flags, int offset, Class<T> type, Object ... arguments) {
        return Methods.find(flags, offset, Constructors.of(type), arguments);
    }

    public static <T> Constructor<T> find(long flags, Class<T> type, Object ... arguments) {
        return Methods.find(flags, Constructors.of(type), arguments);
    }

    public static <T> Constructor<T> find(int offset, Class<T> type, Object ... arguments) {
        return Methods.find(offset, Constructors.of(type), arguments);
    }

    public static <T> Constructor<T> find(int offset, Class<T> type, Class<?> ... parameterTypes) {
        return Methods.find(offset, Constructors.of(type), parameterTypes);
    }

    public static <T> Constructor<T> find(Class<T> type, Object ... arguments) {
        return Methods.find(7L, Constructors.of(type), arguments);
    }

    public static <T> Constructor<T> find(Class<T> type, Class<?> ... parameterTypes) {
        return Methods.find(Constructors.of(type), parameterTypes);
    }

    public static Constructor copy(Constructor constructor) {
        if (constructor == null) {
            return null;
        }
        Constructor root = AccessibleObjects.root(constructor);
        return root == null ? ( /* dynamic constant */ (Object)ConstantBootstraps.invoke("0", new Object[]{lambda$copy$2()})).invokeExact(constructor) : Constructors.copy(root);
    }

    private static /* synthetic */ MethodHandle lambda$copy$2() {
        return Invoker.findSpecial(Constructor.class, "copy", Constructor.class);
    }
}

