/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.stream.Stream;
import net.auoeke.reflect.AccessibleObjects;
import net.auoeke.reflect.CacheMap;
import net.auoeke.reflect.Flags;
import net.auoeke.reflect.Invoker;
import net.auoeke.reflect.Methods;
import net.auoeke.reflect.Pointer;
import net.auoeke.reflect.Types;
import net.gudenau.lib.unsafe.Unsafe;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class Fields {
    public static final Pointer modifiers = Pointer.of(Field.class, "modifiers");
    public static final Pointer override = Pointer.of(AccessibleObject.class, "override");

    public static long offset(Field field) {
        return Flags.isStatic(field) ? Unsafe.staticFieldOffset((Field)field) : Unsafe.objectFieldOffset((Field)field);
    }

    public static long offset(Class<?> declaringType, String name) {
        return Fields.offset(Fields.of(declaringType, name));
    }

    public static Field[] direct(Class<?> type) {
        return ( /* dynamic constant */ (Object)ConstantBootstraps.invoke("0", new Object[]{lambda$direct$3()})).invokeExact(type);
    }

    public static Stream<Field> of(Class<?> type) {
        return Stream.of(((CacheMap)( /* dynamic constant */ (Object)ConstantBootstraps.invoke("1", new Object[]{identity()}))).computeIfAbsent(type, Fields::direct));
    }

    public static Field of(Class<?> type, String name) {
        return (Field)((CacheMap)( /* dynamic constant */ (Object)ConstantBootstraps.invoke("2", new Object[]{identity()}))).computeIfAbsent(type, t -> Fields.of(t).collect(CacheMap::hash, (map, field) -> map.put(field.getName(), field), CacheMap::putAll)).get(name);
    }

    public static Field of(Object object, String name) {
        return Fields.any(object.getClass(), name);
    }

    public static Stream<Field> all(Class<?> begin) {
        return Types.classes(begin, Object.class).flatMap(Fields::of);
    }

    public static Field any(Class<?> type, String name) {
        return Fields.all(type).filter(field -> field.getName().equals(name)).findFirst().orElse(null);
    }

    public static Stream<Field> staticOf(Class<?> type) {
        return Stream.of(((CacheMap)( /* dynamic constant */ (Object)ConstantBootstraps.invoke("3", new Object[]{identity()}))).computeIfAbsent(type, t -> (Field[])Fields.of(t).filter(Flags::isStatic).toArray(Field[]::new)));
    }

    public static Stream<Field> instanceOf(Class<?> type) {
        return Stream.of(((CacheMap)( /* dynamic constant */ (Object)ConstantBootstraps.invoke("4", new Object[]{identity()}))).computeIfAbsent(type, t -> (Field[])Fields.of(t).filter(Flags::isInstance).toArray(Field[]::new)));
    }

    public static Stream<Field> allInstance(Class<?> type) {
        return Types.classes(type, Object.class).flatMap(Fields::of).filter(Flags::isInstance);
    }

    public static Stream<Field> allStatic(Class<?> type) {
        return Types.classes(type, Object.class).flatMap(Fields::of).filter(Flags::isStatic);
    }

    public static Field copy(Field field) {
        if (field == null) {
            return null;
        }
        Field root = AccessibleObjects.root(field);
        return root == null ? ( /* dynamic constant */ (Object)ConstantBootstraps.invoke("5", new Object[]{lambda$copy$11()})).invokeExact(field) : Fields.copy(root);
    }

    private static /* synthetic */ MethodHandle lambda$copy$11() {
        return Invoker.findSpecial(Field.class, "copy", Field.class);
    }

    private static /* synthetic */ MethodHandle lambda$direct$3() {
        return Methods.of(Class.class).filter(method -> Flags.isNative(method) && method.getReturnType() == Field[].class).map(Invoker::unreflectSpecial).map(method -> method.type().parameterCount() > 1 ? MethodHandles.insertArguments(method, 1, false) : method).max(Comparator.comparing(method -> method.invoke(Fields.class).length)).get();
    }
}

