/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.VirtualMachine;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.ConstantBootstraps;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.Map;
import net.auoeke.reflect.Accessor;
import net.auoeke.reflect.Classes;
import net.auoeke.reflect.Exceptions;
import net.auoeke.result.Result;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class Reflect {
    public static Result<Instrumentation> instrument() {
        return  /* dynamic constant */ (Object)ConstantBootstraps.invoke("0", new Object[]{lambda$instrument$8()});
    }

    private static /* synthetic */ Result lambda$instrument$8() {
        String AgentName = Reflect.class.getPackageName() + ".Agent";
        String AgentPath = AgentName.replace('.', '/') + ".class";
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        return Result.of(() -> (Instrumentation)Accessor.getReference(systemLoader.loadClass(AgentName), "instrumentation")).filterNotNull().flatOr(() -> Result.ofVoid(() -> Accessor.putReference(Class.forName("openj9.internal.tools.attach.target.AttachHandler"), "allowAttachSelf", (Object)"true")).flatOr(() -> Result.ofVoid(() -> ((Map)Accessor.getReference(Class.forName("jdk.internal.misc.VM"), "savedProps")).put("jdk.attach.allowAttachSelf", "true")).multiply(() -> Accessor.putBoolean(Class.forName("sun.tools.attach.HotSpotVirtualMachine"), "ALLOW_ATTACH_SELF", true))).thenResult(() -> {
            VirtualMachine vm = VirtualMachine.attach(String.valueOf(ProcessHandle.current().pid()));
            try {
                byte[] manifest = "Agent-Class: %s\nPremain-Class: %1$s\nCan-Redefine-Classes: true\nCan-Retransform-Classes: true\nCan-Set-Native-Method-Prefix: true\n".formatted(AgentName).getBytes();
                String filename = "agent-%s.jar".formatted(HexFormat.of().formatHex(MessageDigest.getInstance("SHA-256").digest(manifest)));
                Path agent = Files.createDirectories(Path.of(System.getProperty("java.io.tmpdir"), "net.auoeke/reflect"), new FileAttribute[0]).resolve(filename);
                if (!Files.exists(agent, new LinkOption[0])) {
                    try (FileSystem jar = FileSystems.newFileSystem(agent, Map.of("create", "true"));){
                        Path manifestPath = jar.getPath("META-INF/MANIFEST.MF", new String[0]);
                        Path classPath = jar.getPath(AgentPath, new String[0]);
                        Files.createDirectories(manifestPath.getParent(), new FileAttribute[0]);
                        Files.createDirectories(classPath.getParent(), new FileAttribute[0]);
                        Files.write(manifestPath, manifest, new OpenOption[0]);
                        Files.write(classPath, Classes.read(Classes.findResource(Reflect.class, AgentPath).openStream()), new OpenOption[0]);
                    }
                    catch (Throwable trouble) {
                        Files.deleteIfExists(agent);
                        throw trouble;
                    }
                }
                try {
                    vm.loadAgent(agent.toString());
                    Instrumentation trouble = (Instrumentation)Accessor.getReference(systemLoader.loadClass(AgentName), "instrumentation");
                    return trouble;
                }
                catch (AgentLoadException exception) {
                    throw Exceptions.message(exception, message -> String.valueOf(agent) + ": " + message);
                }
            }
            finally {
                vm.detach();
            }
        }));
    }
}

