/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class StackFrames {
    public static final StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

    public static Stream<StackWalker.StackFrame> frameStream() {
        return walker.walk(frames -> Stream.of((StackWalker.StackFrame[])frames.toArray(StackWalker.StackFrame[]::new)).skip(1L));
    }

    public static List<StackWalker.StackFrame> frameList() {
        return walker.walk(frames -> frames.skip(1L).toList());
    }

    public static StackWalker.StackFrame first(UnaryOperator<Stream<StackWalker.StackFrame>> transformation) {
        return walker.walk(frames -> (StackWalker.StackFrame)((Stream)transformation.apply(frames.skip(1L))).findFirst().get());
    }

    public static StackWalker.StackFrame frame(int depth) {
        return StackFrames.first(frames -> frames.skip(depth + 1));
    }

    public static StackWalker.StackFrame frame(Predicate<? super StackWalker.StackFrame> predicate) {
        return StackFrames.first(frames -> frames.skip(1L).filter(predicate));
    }

    public static StackWalker.StackFrame frame() {
        return StackFrames.frame(1);
    }

    public static Class<?> caller(Predicate<? super StackWalker.StackFrame> predicate) {
        return StackFrames.first(frames -> frames.skip(2L).filter(predicate)).getDeclaringClass();
    }

    public static Class<?> caller(int depth) {
        return StackFrames.frame(depth + 2).getDeclaringClass();
    }

    public static Class<?> caller() {
        return StackFrames.caller(1);
    }

    public static Stream<StackTraceElement> traceStream(Thread thread) {
        Stream<StackTraceElement> trace = Stream.of(thread.getStackTrace());
        return thread == Thread.currentThread() ? trace.skip(2L) : trace;
    }

    public static StackTraceElement[] trace(Thread thread) {
        StackTraceElement[] trace = thread.getStackTrace();
        return thread == Thread.currentThread() ? Arrays.copyOfRange(trace, 2, trace.length) : trace;
    }

    public static StackTraceElement[] trace() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        return Arrays.copyOfRange(trace, 2, trace.length);
    }

    public static StackTraceElement traceFrame() {
        return StackFrames.trace()[1];
    }
}

