/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import net.auoeke.reflect.Flags;
import net.gudenau.lib.unsafe.Unsafe;

enum TypeInfo {
    VOID(Void.TYPE, Void.class, 0, 0),
    BOOLEAN(Boolean.TYPE, Boolean.class, 1, 0),
    BYTE(Byte.TYPE, Byte.class, 1, 1),
    CHAR(Character.TYPE, Character.class, 2, 1),
    SHORT(Short.TYPE, Short.class, 2, 1),
    INT(Integer.TYPE, Integer.class, 4, 1),
    LONG(Long.TYPE, Long.class, 8, 1),
    FLOAT(Float.TYPE, Float.class, 4, 2),
    DOUBLE(Double.TYPE, Double.class, 8, 2),
    REFERENCE(null, Object.class, Unsafe.ADDRESS_SIZE, 0);

    public final Class<?> primitive;
    public final Class<?> reference;
    public final int size;
    private final int numericType;

    private TypeInfo(Class<?> primitive, Class<?> reference, int size, int numericType) {
        this.primitive = primitive;
        this.reference = reference;
        this.size = size;
        this.numericType = numericType;
    }

    public static TypeInfo of(Class<?> type) {
        if (type == Integer.TYPE) {
            return INT;
        }
        if (type == Float.TYPE) {
            return FLOAT;
        }
        if (type == Boolean.TYPE) {
            return BOOLEAN;
        }
        if (type == Byte.TYPE) {
            return BYTE;
        }
        if (type == Long.TYPE) {
            return LONG;
        }
        if (type == Double.TYPE) {
            return DOUBLE;
        }
        if (type == Character.TYPE) {
            return CHAR;
        }
        if (type == Void.TYPE) {
            return VOID;
        }
        if (type == Short.TYPE) {
            return SHORT;
        }
        if (type == Integer.class) {
            return INT;
        }
        if (type == Float.class) {
            return FLOAT;
        }
        if (type == Boolean.class) {
            return BOOLEAN;
        }
        if (type == Byte.class) {
            return BYTE;
        }
        if (type == Long.class) {
            return LONG;
        }
        if (type == Double.class) {
            return DOUBLE;
        }
        if (type == Character.class) {
            return CHAR;
        }
        if (type == Void.class) {
            return VOID;
        }
        if (type == Short.class) {
            return SHORT;
        }
        return REFERENCE;
    }

    public boolean isVoid() {
        return this == VOID;
    }

    public boolean isPrimitive() {
        return this.primitive != null && !this.isVoid();
    }

    public boolean isBoolean() {
        return this == BOOLEAN;
    }

    public boolean isInteger() {
        return this.numericType == 1;
    }

    public boolean isFloat() {
        return this.numericType == 2;
    }

    public boolean isReference() {
        return this == REFERENCE;
    }

    public boolean isNumeric() {
        return this.numericType != 0;
    }

    public boolean canWiden(TypeInfo from) {
        return this.isNumeric() && from.isNumeric() && Flags.any(this.numericType, (long)(2 | from.numericType)) && this.size >= from.size;
    }

    private static class NumericTypes {
        static final int INTEGER = 1;
        static final int FLOAT = 2;

        private NumericTypes() {
        }
    }
}

