/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.auoeke.reflect.CacheMap;
import net.auoeke.reflect.Classes;
import net.auoeke.reflect.Fields;
import net.auoeke.reflect.Flags;
import net.auoeke.reflect.TypeInfo;
import net.gudenau.lib.unsafe.Unsafe;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class Types {
    public static final long WIDEN = 1L;
    public static final long UNBOX = 2L;
    public static final long BOX = 4L;
    public static final long REWRAP = 8L;
    public static final long DEFAULT_CONVERSION = 7L;

    public static Stream<Class<?>> stackPrimitives() {
        return Stream.of(Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    }

    public static Stream<Class<?>> stackBase() {
        return Stream.of(Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Object.class);
    }

    public static Stream<Class<?>> returnPrimitives() {
        return Stream.of(Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE);
    }

    public static Stream<Class<?>> interfaces(Class<?> type) {
        return Stream.of(type.getInterfaces());
    }

    public static Stream<Class<?>> supertypes(Class<?> type) {
        Class<?> superclass = type.getSuperclass();
        Stream<Class<?>> interfaces = Types.interfaces(type);
        return superclass == null ? interfaces : Stream.concat(Stream.of(superclass), interfaces);
    }

    public static <T> Stream<Class<?>> classes(Class<T> begin, Class<?> end) {
        return Stream.iterate(begin, type -> type != end, Class::getSuperclass);
    }

    public static <T> Stream<Class<?>> classes(Class<T> begin) {
        return Types.classes(begin, null);
    }

    public static Stream<Class<?>> allInterfaces(Class<?> type) {
        return Types.classes(type).flatMap(Types::interfaces).distinct();
    }

    public static <T> Stream<Class<?>> hierarchy(Class<T> type) {
        return Stream.of(type).mapMulti((t, add) -> {
            add.accept(t);
            Types.supertypes(type).forEach(supertype -> Types.hierarchy(supertype).forEach((Consumer<Class<?>>)add));
        }).distinct();
    }

    public static Stream<Class<?>> baseTypes(Class<?> type) {
        return Types.supertypes(type).flatMap(Types::hierarchy).distinct();
    }

    public static int depth(Class<?> type, boolean interfaces) {
        return type == null ? 0 : (interfaces ? 1 + ((CacheMap)( /* dynamic constant */ (Object)ConstantBootstraps.invoke("0", new Object[]{identity()}))).computeIfAbsent(type, t -> Types.allInterfaces(t).mapToInt(t1 -> Types.depth(t1, true)).max().orElse(0)) : ((CacheMap)( /* dynamic constant */ (Object)ConstantBootstraps.invoke("1", new Object[]{identity()}))).computeIfAbsent(type, t -> (int)Types.classes(t).count()));
    }

    public static int depth(Class<?> type) {
        return Types.depth(type, type != null && type.isInterface());
    }

    public static int difference(Class<?> a, Class<?> b, boolean interfaces) {
        return a == null || b == null || a.isAssignableFrom(b) || b.isAssignableFrom(a) ? Types.depth(a, interfaces) - Types.depth(b, interfaces) : Integer.MAX_VALUE;
    }

    public static int difference(Class<?> a, Class<?> b) {
        return Types.difference(a, b, a != null && a.isInterface() || b != null && b.isInterface());
    }

    public static int stackSize(Class<?> type) {
        return (type.isPrimitive() ? TypeInfo.of(type) : TypeInfo.REFERENCE).size;
    }

    public static int size(Class<?> type) {
        return ((CacheMap)( /* dynamic constant */ (Object)ConstantBootstraps.invoke("2", new Object[]{lambda$size$6()}))).computeIfAbsent(type, t -> t.isArray() ? Unsafe.arrayBaseOffset((Class)t) + Unsafe.arrayIndexScale((Class)t) * Array.getLength(t) : (int)Types.classes(type).flatMap(Fields::instanceOf).mapToLong(field -> Unsafe.objectFieldOffset((Field)field) + (long)Types.stackSize(field.getType())).max().orElse(Classes.firstField.offset));
    }

    public static Class<?> unbox(Class<?> type) {
        return type.isPrimitive() ? type : TypeInfo.of(type).primitive;
    }

    public static Class<?> box(Class<?> type) {
        return type.isPrimitive() ? TypeInfo.of(type).reference : type;
    }

    public static boolean equals(Class<?> type, Class<?> other) {
        return type == other || type != null && other != null && (Types.unbox(type) == other || Types.unbox(other) == type);
    }

    public static boolean isWrapper(Class<?> type) {
        return !type.isPrimitive() && Types.unbox(type) != null;
    }

    public static boolean isSubtype(Class<?> subtype, Class<?> supertype) {
        return subtype != null && supertype != null && subtype != supertype && supertype.isAssignableFrom(subtype);
    }

    public static boolean canCast(long flags, Class<?> left, Class<?> right) {
        if (left.isAssignableFrom(right)) {
            return true;
        }
        if (left.isPrimitive()) {
            return Flags.any(flags, 2L) && Types.unbox(right) == left || Flags.any(flags, 1L) && (Flags.any(flags, 2L) || right.isPrimitive()) && TypeInfo.of(left).canWiden(TypeInfo.of(right));
        }
        return Flags.any(flags, 4L) && left == Types.box(right) || Flags.any(flags, 8L) && !right.isPrimitive() && TypeInfo.of(left).canWiden(TypeInfo.of(right));
    }

    public static boolean canCast(Class<?> left, Class<?> right) {
        return Types.canCast(7L, left, right);
    }

    public static boolean canCast(long flags, int offset, Class<?>[] left, Class<?> ... right) {
        if (left.length == right.length + offset) {
            if (flags == 0L) {
                return Arrays.equals(left, offset, left.length, right, 0, right.length);
            }
            for (int i = offset; i != left.length; ++i) {
                if (Types.canCast(flags, left[i], right[i - offset])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean canCast(long flags, int offset, Class<?>[] left, Object ... right) {
        return Types.canCast(flags, offset, left, (Class[])Stream.of(right).map(Object::getClass).toArray(Class[]::new));
    }

    public static boolean canCast(long flags, Class<?>[] left, Class<?> ... right) {
        return Types.canCast(flags, 0, left, right);
    }

    public static boolean canCast(long flags, Class<?>[] left, Object ... right) {
        return Types.canCast(flags, 0, left, right);
    }

    public static boolean canCast(int offset, Class<?>[] left, Class<?> ... right) {
        return Types.canCast(7L, offset, left, right);
    }

    public static boolean canCast(int offset, Class<?>[] left, Object ... right) {
        return Types.canCast(7L, offset, left, right);
    }

    public static boolean canCast(Class<?>[] left, Class<?> ... right) {
        return Types.canCast(7L, 0, left, right);
    }

    public static boolean canCast(Class<?>[] left, Object ... right) {
        return Types.canCast(7L, 0, left, right);
    }

    public static <T> T[] box(Object array) {
        Object object;
        if (array instanceof boolean[]) {
            boolean[] b = (boolean[])array;
            object = Types.box(b);
        } else if (array instanceof byte[]) {
            byte[] b = (byte[])array;
            object = Types.box(b);
        } else if (array instanceof char[]) {
            char[] c = (char[])array;
            object = Types.box(c);
        } else if (array instanceof short[]) {
            short[] s = (short[])array;
            object = Types.box(s);
        } else if (array instanceof int[]) {
            int[] i = (int[])array;
            object = Types.box(i);
        } else if (array instanceof long[]) {
            long[] l = (long[])array;
            object = Types.box(l);
        } else if (array instanceof float[]) {
            float[] f = (float[])array;
            object = Types.box(f);
        } else if (array instanceof double[]) {
            double[] d = (double[])array;
            object = Types.box(d);
        } else {
            object = array;
        }
        return object;
    }

    public static <T> T unbox(Object array) {
        TypeDescriptor.OfField type = array.getClass().componentType();
        if (((Class)type).isPrimitive()) {
            return (T)array;
        }
        Class<?> primitive = Types.unbox(type);
        return primitive == null || primitive == type ? null : (T)Types.convert(array, primitive);
    }

    public static <T> T unbox(Object array, Class<?> componentType) {
        if (!componentType.isPrimitive()) {
            throw new IllegalArgumentException(String.valueOf(componentType) + " is not primitive");
        }
        return Types.convert(array, componentType);
    }

    public static <T> T convert(Object array, Class<?> componentType) {
        if (array.getClass().componentType() == componentType) {
            return (T)array;
        }
        int length = Array.getLength(array);
        Object boxed = Array.newInstance(componentType, length);
        IntStream.range(0, length).forEach(index -> Array.set(boxed, index, Array.get(array, index)));
        return (T)boxed;
    }

    public static Boolean[] box(boolean[] array) {
        Boolean[] box = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            box[i] = array[i];
        }
        return box;
    }

    public static Byte[] box(byte[] array) {
        Byte[] box = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            box[i] = array[i];
        }
        return box;
    }

    public static Character[] box(char[] array) {
        Character[] box = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            box[i] = Character.valueOf(array[i]);
        }
        return box;
    }

    public static Short[] box(short[] array) {
        Short[] box = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            box[i] = array[i];
        }
        return box;
    }

    public static Integer[] box(int[] array) {
        Integer[] box = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            box[i] = array[i];
        }
        return box;
    }

    public static Long[] box(long[] array) {
        Long[] box = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            box[i] = array[i];
        }
        return box;
    }

    public static Float[] box(float[] array) {
        Float[] box = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            box[i] = Float.valueOf(array[i]);
        }
        return box;
    }

    public static Double[] box(double[] array) {
        Double[] box = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            box[i] = array[i];
        }
        return box;
    }

    private static /* synthetic */ CacheMap lambda$size$6() {
        CacheMap<Class<Double>, Integer> map = CacheMap.identity();
        map.putAll(Map.of(Void.TYPE, 0, Boolean.TYPE, 1, Byte.TYPE, 1, Character.TYPE, 2, Short.TYPE, 2, Integer.TYPE, 4, Float.TYPE, 4, Long.TYPE, 8, Double.TYPE, 8));
        return map;
    }
}

