/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.cim;

import java.util.ArrayList;
import net.authorize.AuthNetField;
import net.authorize.cim.Transaction;
import net.authorize.data.cim.CustomerProfile;
import net.authorize.data.cim.DirectResponse;
import net.authorize.data.cim.PaymentProfile;
import net.authorize.data.creditcard.CreditCard;
import net.authorize.data.echeck.BankAccountType;
import net.authorize.data.xml.Address;
import net.authorize.data.xml.BankAccount;
import net.authorize.data.xml.CustomerType;
import net.authorize.data.xml.Payment;
import net.authorize.util.BasicXmlDocument;
import net.authorize.util.StringUtils;
import net.authorize.xml.Message;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class Result<T>
extends net.authorize.xml.Result<T> {
    private static final long serialVersionUID = 1L;
    protected String refId;
    protected ArrayList<String> customerProfileIdList = new ArrayList();
    protected CustomerProfile customerProfile;
    protected String token;
    protected ArrayList<String> customerPaymentProfileIdList = new ArrayList();
    protected ArrayList<PaymentProfile> paymentProfileList = new ArrayList();
    protected ArrayList<String> customerShippingAddressIdList = new ArrayList();
    protected ArrayList<DirectResponse> directResponseList = new ArrayList();

    public static <T> Result<T> createResult(T object, BasicXmlDocument response) {
        Result<T> result = new Result<T>();
        if (object instanceof Transaction) {
            Transaction targetTransaction = Transaction.createTransaction((Transaction)object, response);
            super.importRefId(targetTransaction);
            super.importResponseMessages(targetTransaction);
            super.importCustomerPaymentProfileId(targetTransaction);
            super.importCustomerShippingAddressIdList(targetTransaction);
            super.importCustomerShippingAddressId(targetTransaction);
            super.importDirectResponse(targetTransaction);
            switch (targetTransaction.getTransactionType()) {
                case GET_CUSTOMER_PROFILE_IDS: {
                    super.importCustomerProfileIdList(targetTransaction);
                    break;
                }
                case GET_CUSTOMER_PAYMENT_PROFILE: {
                    super.importCustomerPaymentProfile(targetTransaction);
                    break;
                }
                case GET_CUSTOMER_PROFILE: {
                    super.importCustomerProfile(targetTransaction);
                    break;
                }
                case GET_CUSTOMER_SHIPPING_ADDRESS: {
                    super.importShippingAddress(targetTransaction);
                    break;
                }
                case GET_HOSTED_PROFILE_PAGE: {
                    super.importToken(targetTransaction);
                    break;
                }
            }
            result.target = targetTransaction;
        }
        return result;
    }

    private void importResponseMessages(Transaction txn) {
        NodeList messages_list = txn.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT_MESSAGES.getFieldName());
        if (messages_list.getLength() == 0) {
            return;
        }
        Element messages_el = (Element)messages_list.item(0);
        this.resultCode = Result.getElementText(messages_el, AuthNetField.ELEMENT_RESULT_CODE.getFieldName());
        String customerProfileId = Result.getElementText(txn.getCurrentResponse().getDocumentElement(), AuthNetField.ELEMENT_CUSTOMER_PROFILE_ID.getFieldName());
        if (!StringUtils.isEmpty(customerProfileId)) {
            this.customerProfileIdList.add(customerProfileId);
        }
        NodeList message_list = messages_el.getElementsByTagName(AuthNetField.ELEMENT_MESSAGE.getFieldName());
        for (int i = 0; i < message_list.getLength(); ++i) {
            Element message_el = (Element)message_list.item(i);
            Message new_message = Message.createMessage();
            new_message.setCode(Result.getElementText(message_el, AuthNetField.ELEMENT_CODE.getFieldName()));
            new_message.setText(Result.getElementText(message_el, AuthNetField.ELEMENT_TEXT.getFieldName()));
            this.messages.add(new_message);
        }
    }

    private void importRefId(Transaction txn) {
        this.refId = Result.getElementText(txn.getCurrentResponse().getDocument().getDocumentElement(), AuthNetField.ELEMENT_REFID.getFieldName());
    }

    private void importCustomerShippingAddressId(Transaction txn) {
        String customerShippingAddress = Result.getElementText(txn.getCurrentResponse().getDocument().getDocumentElement(), AuthNetField.ELEMENT_CUSTOMER_ADDRESS_ID.getFieldName());
        if (!StringUtils.isEmpty(customerShippingAddress)) {
            this.customerShippingAddressIdList.add(customerShippingAddress);
        }
    }

    private void importToken(Transaction txn) {
        this.token = Result.getElementText(txn.getCurrentResponse().getDocument().getDocumentElement(), AuthNetField.ELEMENT_TOKEN.getFieldName());
    }

    private void importCustomerPaymentProfileId(Transaction txn) {
        block3: {
            block2: {
                NodeList payment_profile_id_list = txn.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT_CUSTOMER_PAYMENT_PROFILE_ID_LIST.getFieldName());
                if (payment_profile_id_list.getLength() != 1) break block2;
                Element payment_profile_id_el = (Element)payment_profile_id_list.item(0);
                NodeList numeric_list = payment_profile_id_el.getChildNodes();
                for (int i = 0; i < numeric_list.getLength(); ++i) {
                    String numericStr = numeric_list.item(i).getTextContent();
                    if (StringUtils.isEmpty(numericStr)) continue;
                    this.customerPaymentProfileIdList.add(numericStr);
                }
                break block3;
            }
            NodeList payment_profile_list = txn.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT_CUSTOMER_PAYMENT_PROFILE_ID.getFieldName());
            if (payment_profile_list.getLength() <= 0) break block3;
            for (int i = 0; i < payment_profile_list.getLength(); ++i) {
                String paymentProfileID = payment_profile_list.item(i).getTextContent();
                if (StringUtils.isEmpty(paymentProfileID)) continue;
                this.customerPaymentProfileIdList.add(paymentProfileID);
            }
        }
    }

    private void importCustomerShippingAddressIdList(Transaction txn) {
        NodeList shipping_address_id_list = txn.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT_CUSTOMER_SHIPPING_ADDRESS_ID_LIST.getFieldName());
        if (shipping_address_id_list.getLength() == 1) {
            Element shipping_address_id_el = (Element)shipping_address_id_list.item(0);
            NodeList numeric_list = shipping_address_id_el.getChildNodes();
            for (int i = 0; i < numeric_list.getLength(); ++i) {
                String numericStr = numeric_list.item(i).getTextContent();
                if (StringUtils.isEmpty(numericStr)) continue;
                this.customerShippingAddressIdList.add(numericStr);
            }
        }
    }

    private void importCustomerProfileIdList(Transaction txn) {
        NodeList profile_id_list = txn.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT_IDS.getFieldName());
        if (profile_id_list.getLength() == 1) {
            Element profile_id_el = (Element)profile_id_list.item(0);
            NodeList numeric_list = profile_id_el.getChildNodes();
            for (int i = 0; i < numeric_list.getLength(); ++i) {
                String numericStr = numeric_list.item(i).getTextContent();
                if (StringUtils.isEmpty(numericStr)) continue;
                this.customerProfileIdList.add(numericStr);
            }
        }
    }

    private void importCustomerProfile(Transaction transaction) {
        NodeList profile_list = transaction.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT_PROFILE.getFieldName());
        if (profile_list.getLength() == 0) {
            return;
        }
        Element profile_el = (Element)profile_list.item(0);
        this.customerProfile = CustomerProfile.createCustomerProfile();
        this.customerProfile.setMerchantCustomerId(Result.getElementText(profile_el, AuthNetField.ELEMENT_MERCHANT_CUSTOMER_ID.getFieldName()));
        this.customerProfile.setDescription(Result.getElementText(profile_el, AuthNetField.ELEMENT_DESCRIPTION.getFieldName()));
        this.customerProfile.setEmail(Result.getElementText(profile_el, AuthNetField.ELEMENT_EMAIL.getFieldName()));
        this.customerProfile.setCustomerProfileId(Result.getElementText(profile_el, AuthNetField.ELEMENT_CUSTOMER_PROFILE_ID.getFieldName()));
        this.importPaymentProfiles(profile_el);
        this.importShipToList(profile_el, this.customerProfile);
    }

    private void importShippingAddress(Transaction transaction) {
        NodeList address_list = transaction.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT_ADDRESS.getFieldName());
        if (address_list.getLength() == 0) {
            return;
        }
        Element address_el = (Element)address_list.item(0);
        this.customerProfile = CustomerProfile.createCustomerProfile();
        Address shipToAddress = Address.createAddress();
        shipToAddress.setFirstName(Result.getElementText(address_el, AuthNetField.ELEMENT_FIRST_NAME.getFieldName()));
        shipToAddress.setLastName(Result.getElementText(address_el, AuthNetField.ELEMENT_LAST_NAME.getFieldName()));
        shipToAddress.setCompany(Result.getElementText(address_el, AuthNetField.ELEMENT_COMPANY.getFieldName()));
        shipToAddress.setAddress(Result.getElementText(address_el, AuthNetField.ELEMENT_ADDRESS.getFieldName()));
        shipToAddress.setCity(Result.getElementText(address_el, AuthNetField.ELEMENT_CITY.getFieldName()));
        shipToAddress.setState(Result.getElementText(address_el, AuthNetField.ELEMENT_STATE.getFieldName()));
        shipToAddress.setZipPostalCode(Result.getElementText(address_el, AuthNetField.ELEMENT_ZIP.getFieldName()));
        shipToAddress.setCountry(Result.getElementText(address_el, AuthNetField.ELEMENT_COUNTRY.getFieldName()));
        shipToAddress.setPhoneNumber(Result.getElementText(address_el, AuthNetField.ELEMENT_PHONE_NUMBER.getFieldName()));
        shipToAddress.setFaxNumber(Result.getElementText(address_el, AuthNetField.ELEMENT_FAX_NUMBER.getFieldName()));
        shipToAddress.setAddressId(Result.getElementText(address_el, AuthNetField.ELEMENT_CUSTOMER_SHIPPING_ADDRESS_ID.getFieldName()));
        this.customerProfile.addShipToAddress(shipToAddress);
    }

    private void importShipToList(Element root_el, CustomerProfile customerProfile) {
        NodeList ship_to_list = root_el.getElementsByTagName(AuthNetField.ELEMENT_SHIP_TO_LIST.getFieldName());
        for (int i = 0; i < ship_to_list.getLength(); ++i) {
            Address shipToAddress = Address.createAddress();
            Element ship_to_el = (Element)ship_to_list.item(i);
            shipToAddress.setFirstName(Result.getElementText(ship_to_el, AuthNetField.ELEMENT_FIRST_NAME.getFieldName()));
            shipToAddress.setLastName(Result.getElementText(ship_to_el, AuthNetField.ELEMENT_LAST_NAME.getFieldName()));
            shipToAddress.setCompany(Result.getElementText(ship_to_el, AuthNetField.ELEMENT_COMPANY.getFieldName()));
            shipToAddress.setAddress(Result.getElementText(ship_to_el, AuthNetField.ELEMENT_ADDRESS.getFieldName()));
            shipToAddress.setCity(Result.getElementText(ship_to_el, AuthNetField.ELEMENT_CITY.getFieldName()));
            shipToAddress.setState(Result.getElementText(ship_to_el, AuthNetField.ELEMENT_STATE.getFieldName()));
            shipToAddress.setZipPostalCode(Result.getElementText(ship_to_el, AuthNetField.ELEMENT_ZIP.getFieldName()));
            shipToAddress.setCountry(Result.getElementText(ship_to_el, AuthNetField.ELEMENT_COUNTRY.getFieldName()));
            shipToAddress.setPhoneNumber(Result.getElementText(ship_to_el, AuthNetField.ELEMENT_PHONE_NUMBER.getFieldName()));
            shipToAddress.setFaxNumber(Result.getElementText(ship_to_el, AuthNetField.ELEMENT_FAX_NUMBER.getFieldName()));
            shipToAddress.setAddressId(Result.getElementText(ship_to_el, AuthNetField.ELEMENT_CUSTOMER_ADDRESS_ID.getFieldName()));
            customerProfile.addShipToAddress(shipToAddress);
        }
    }

    private void importPaymentProfiles(Element root_el) {
        NodeList payment_profile_list = root_el.getElementsByTagName(AuthNetField.ELEMENT_PAYMENT_PROFILES.getFieldName());
        for (int i = 0; i < payment_profile_list.getLength(); ++i) {
            PaymentProfile paymentProfile = PaymentProfile.createPaymentProfile();
            Element payment_profile_el = (Element)payment_profile_list.item(i);
            paymentProfile.setCustomerType(CustomerType.findByName(Result.getElementText(payment_profile_el, AuthNetField.ELEMENT_CUSTOMER_TYPE.getFieldName())));
            this.importBillTo(payment_profile_el, paymentProfile);
            paymentProfile.setCustomerPaymentProfileId(Result.getElementText(payment_profile_el, AuthNetField.ELEMENT_CUSTOMER_PAYMENT_PROFILE_ID.getFieldName()));
            this.importPaymentInfo(payment_profile_el, paymentProfile);
            this.paymentProfileList.add(paymentProfile);
        }
    }

    private void importCustomerPaymentProfile(Transaction transaction) {
        NodeList payment_profile_list = transaction.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT_PAYMENT_PROFILE.getFieldName());
        if (payment_profile_list.getLength() == 0) {
            return;
        }
        Element payment_profile_el = (Element)payment_profile_list.item(0);
        PaymentProfile paymentProfile = PaymentProfile.createPaymentProfile();
        paymentProfile.setCustomerType(CustomerType.findByName(Result.getElementText(payment_profile_el, AuthNetField.ELEMENT_CUSTOMER_TYPE.getFieldName())));
        this.importBillTo(payment_profile_el, paymentProfile);
        paymentProfile.setCustomerPaymentProfileId(Result.getElementText(payment_profile_el, AuthNetField.ELEMENT_CUSTOMER_PAYMENT_PROFILE_ID.getFieldName()));
        this.importPaymentInfo(payment_profile_el, paymentProfile);
        this.paymentProfileList.add(paymentProfile);
    }

    private void importBillTo(Element root_el, PaymentProfile paymentProfile) {
        NodeList bill_to_list = root_el.getElementsByTagName(AuthNetField.ELEMENT_BILL_TO.getFieldName());
        if (bill_to_list.getLength() == 1) {
            Element bill_to_el = (Element)bill_to_list.item(0);
            Address billTo = Address.createAddress();
            billTo.setFirstName(Result.getElementText(bill_to_el, AuthNetField.ELEMENT_FIRST_NAME.getFieldName()));
            billTo.setLastName(Result.getElementText(bill_to_el, AuthNetField.ELEMENT_LAST_NAME.getFieldName()));
            billTo.setCompany(Result.getElementText(bill_to_el, AuthNetField.ELEMENT_COMPANY.getFieldName()));
            billTo.setAddress(Result.getElementText(bill_to_el, AuthNetField.ELEMENT_ADDRESS.getFieldName()));
            billTo.setCity(Result.getElementText(bill_to_el, AuthNetField.ELEMENT_CITY.getFieldName()));
            billTo.setState(Result.getElementText(bill_to_el, AuthNetField.ELEMENT_STATE.getFieldName()));
            billTo.setZipPostalCode(Result.getElementText(bill_to_el, AuthNetField.ELEMENT_ZIP.getFieldName()));
            billTo.setCountry(Result.getElementText(bill_to_el, AuthNetField.ELEMENT_COUNTRY.getFieldName()));
            billTo.setPhoneNumber(Result.getElementText(bill_to_el, AuthNetField.ELEMENT_PHONE_NUMBER.getFieldName()));
            paymentProfile.setBillTo(billTo);
        }
    }

    private void importPaymentInfo(Element root_el, PaymentProfile paymentProfile) {
        NodeList bank_account_list;
        NodeList payment_list = root_el.getElementsByTagName(AuthNetField.ELEMENT_PAYMENT.getFieldName());
        if (payment_list.getLength() == 0) {
            return;
        }
        Element payment_el = (Element)payment_list.item(0);
        NodeList credit_card_list = payment_el.getElementsByTagName(AuthNetField.ELEMENT_CREDIT_CARD.getFieldName());
        if (credit_card_list.getLength() != 0) {
            Element credit_card_el = (Element)credit_card_list.item(0);
            CreditCard creditCard = CreditCard.createCreditCard();
            creditCard.setMaskedCreditCardNumber(Result.getElementText(credit_card_el, AuthNetField.ELEMENT_CREDIT_CARD_NUMBER.getFieldName()));
            String dateStr = Result.getElementText(credit_card_el, AuthNetField.ELEMENT_CREDIT_CARD_EXPIRY.getFieldName());
            if (StringUtils.isNotEmpty(dateStr) && !"XXXX".equals(dateStr)) {
                creditCard.setExpirationDate(Result.getElementText(credit_card_el, AuthNetField.ELEMENT_CREDIT_CARD_EXPIRY.getFieldName()));
            }
            paymentProfile.addPayment(Payment.createPayment(creditCard));
        }
        if ((bank_account_list = payment_el.getElementsByTagName(AuthNetField.ELEMENT_BANK_ACCOUNT.getFieldName())).getLength() != 0) {
            Element bank_account_el = (Element)bank_account_list.item(0);
            BankAccount bankAccount = BankAccount.createBankAccount();
            bankAccount.setBankAccountType(BankAccountType.findByValue(Result.getElementText(bank_account_el, AuthNetField.ELEMENT_ACCOUNT_TYPE.getFieldName())));
            bankAccount.setRoutingNumber(Result.getElementText(bank_account_el, AuthNetField.ELEMENT_ROUTING_NUMBER.getFieldName()));
            bankAccount.setBankAccountNumber(Result.getElementText(bank_account_el, AuthNetField.ELEMENT_ACCOUNT_NUMBER.getFieldName()));
            bankAccount.setBankAccountName(Result.getElementText(bank_account_el, AuthNetField.ELEMENT_NAME_ON_ACCOUNT.getFieldName()));
            bankAccount.setBankName(Result.getElementText(bank_account_el, AuthNetField.ELEMENT_BANK_NAME.getFieldName()));
            paymentProfile.addPayment(Payment.createPayment(bankAccount));
        }
    }

    private void importDirectResponse(Transaction txn) {
        NodeList validation_direct_response_list = txn.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT_VALIDATION_DIRECT_RESPONSE_LIST.getFieldName());
        if (validation_direct_response_list.getLength() > 0) {
            for (int i = 0; i < validation_direct_response_list.getLength(); ++i) {
                Element validation_direct_response_el = (Element)validation_direct_response_list.item(i);
                String validationDirectResponseStr = validation_direct_response_el.getTextContent();
                if (StringUtils.isEmpty(validationDirectResponseStr)) continue;
                DirectResponse validationDirectResponse = DirectResponse.createDirectResponse(validationDirectResponseStr);
                this.directResponseList.add(validationDirectResponse);
            }
        } else {
            String directResponseStr = Result.getElementText(txn.getCurrentResponse().getDocument().getDocumentElement(), AuthNetField.ELEMENT_VALIDATION_DIRECT_RESPONSE.getFieldName());
            if (StringUtils.isEmpty(directResponseStr)) {
                directResponseStr = Result.getElementText(txn.getCurrentResponse().getDocument().getDocumentElement(), AuthNetField.ELEMENT_DIRECT_RESPONSE.getFieldName());
            }
            if (!StringUtils.isEmpty(directResponseStr)) {
                DirectResponse validationDirectResponse = DirectResponse.createDirectResponse(directResponseStr);
                this.directResponseList.add(validationDirectResponse);
            }
        }
    }

    public String getCustomerProfileId() {
        String retval = null;
        if (this.customerProfileIdList != null && !this.customerProfileIdList.isEmpty()) {
            retval = this.customerProfileIdList.get(0);
        }
        return retval;
    }

    public ArrayList<DirectResponse> getDirectResponseList() {
        return this.directResponseList;
    }

    public String getRefId() {
        return this.refId;
    }

    public String getToken() {
        return this.token;
    }

    public ArrayList<String> getCustomerPaymentProfileIdList() {
        return this.customerPaymentProfileIdList;
    }

    public ArrayList<String> getCustomerShippingAddressIdList() {
        return this.customerShippingAddressIdList;
    }

    public ArrayList<String> getCustomerProfileIdList() {
        return this.customerProfileIdList;
    }

    public ArrayList<PaymentProfile> getCustomerPaymentProfileList() {
        return this.paymentProfileList;
    }

    public PaymentProfile getCustomerPaymentProfile() {
        PaymentProfile retval = null;
        if (this.paymentProfileList != null && !this.paymentProfileList.isEmpty()) {
            retval = this.paymentProfileList.get(0);
        }
        return retval;
    }

    public CustomerProfile getCustomerProfile() {
        return this.customerProfile;
    }

    @Override
    public void printMessages() {
        System.out.println("Result Code: " + (this.resultCode != null ? this.resultCode : "No result code"));
        if (this.getCustomerProfileId() != null) {
            System.out.println("Result customerProfile Id: " + this.getCustomerProfileId());
        }
        for (Message message : this.messages) {
            System.out.println(message.getCode() + " - " + message.getText());
        }
    }
}

