/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.automatalib.words.SharedWord;
import net.automatalib.words.Word;

final class LetterWord<I>
extends Word<I> {
    private final I letter;

    public LetterWord(I letter) {
        this.letter = letter;
    }

    @Override
    public I getSymbol(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.letter;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public Word<I> _subWord(int fromIndex, int toIndex) {
        if (fromIndex > 0 || toIndex == 0) {
            return Word.epsilon();
        }
        return this;
    }

    @Override
    public java.util.Iterator<I> iterator() {
        return new Iterator<I>(this.letter);
    }

    @Override
    public void writeToArray(int offset, Object[] array, int tgtOffset, int length) {
        if (offset == 0 && length > 0) {
            array[tgtOffset] = this.letter;
        }
    }

    @Override
    public I lastSymbol() {
        return this.letter;
    }

    @Override
    public List<I> asList() {
        return Collections.singletonList(this.letter);
    }

    @Override
    public Word<I> prepend(I symbol) {
        Object[] array = new Object[]{symbol, this.letter};
        return new SharedWord(array);
    }

    @Override
    public Word<I> append(I symbol) {
        Object[] array = new Object[]{this.letter, symbol};
        return new SharedWord(array);
    }

    @Override
    public boolean isPrefixOf(Word<I> other) {
        if (other.length() == 0) {
            return false;
        }
        return Objects.equals(this.letter, other.getSymbol(0));
    }

    @Override
    public Word<I> longestCommonPrefix(Word<I> other) {
        if (this.isPrefixOf(other)) {
            return this;
        }
        return Word.epsilon();
    }

    @Override
    public boolean isSuffixOf(Word<I> other) {
        if (other.isEmpty()) {
            return false;
        }
        return Objects.equals(this.letter, other.lastSymbol());
    }

    @Override
    public Word<I> longestCommonSuffix(Word<I> other) {
        if (this.isSuffixOf(other)) {
            return this;
        }
        return Word.epsilon();
    }

    @Override
    public Word<I> flatten() {
        return this;
    }

    @Override
    public Word<I> trimmed() {
        return this;
    }

    private static final class Iterator<I>
    implements java.util.Iterator<I> {
        private final I letter;
        private boolean next = true;

        public Iterator(I letter) {
            this.letter = letter;
        }

        @Override
        public boolean hasNext() {
            return this.next;
        }

        @Override
        public I next() {
            if (this.next) {
                this.next = false;
                return this.letter;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

