/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words;

import java.util.List;
import java.util.ListIterator;
import net.automatalib.words.Word;

final class SharedWord<I>
extends Word<I> {
    private final Object[] storage;
    private final int offset;
    private final int length;

    public SharedWord(Object[] storage) {
        this(storage, 0, storage.length);
    }

    public SharedWord(Object[] storage, int offset, int length) {
        this.storage = storage;
        this.offset = offset;
        this.length = length;
    }

    public SharedWord(List<? extends I> other) {
        this.storage = other.toArray();
        this.offset = 0;
        this.length = other.size();
    }

    @Override
    public I getSymbol(int index) {
        return (I)this.storage[this.offset + index];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public Word<I> _subWord(int fromIndex, int toIndex) {
        int newOfs = this.offset + fromIndex;
        int newLen = toIndex - fromIndex;
        if (newLen <= 0) {
            return Word.epsilon();
        }
        if (newOfs + newLen > this.storage.length) {
            return Word.epsilon();
        }
        return new SharedWord<I>(this.storage, newOfs, newLen);
    }

    @Override
    public void writeToArray(int offset, Object[] array, int tgtOfs, int num) {
        System.arraycopy(this.storage, this.offset + offset, array, tgtOfs, num);
    }

    @Override
    public I lastSymbol() {
        return (I)this.storage[this.length - 1];
    }

    @Override
    public Iterator<I> iterator() {
        return new Iterator(this);
    }

    @Override
    public Word<I> flatten() {
        return this;
    }

    @Override
    public Word<I> trimmed() {
        if (this.offset == 0 && this.length == this.storage.length) {
            return this;
        }
        Object[] trimmed = new Object[this.length];
        System.arraycopy(this.storage, this.offset, trimmed, 0, this.length);
        return new SharedWord<I>(trimmed);
    }

    private static final class Iterator<I>
    implements ListIterator<I> {
        private final Object[] storage;
        private final int startIdx;
        private final int endIdx;
        private int currIdx;

        public Iterator(SharedWord<I> word) {
            this(word, 0);
        }

        public Iterator(SharedWord<I> word, int index) {
            this.storage = ((SharedWord)word).storage;
            this.startIdx = ((SharedWord)word).offset;
            this.currIdx = ((SharedWord)word).offset + index;
            this.endIdx = ((SharedWord)word).offset + ((SharedWord)word).length;
        }

        @Override
        public boolean hasNext() {
            return this.currIdx < this.endIdx;
        }

        @Override
        public I next() {
            return (I)this.storage[this.currIdx++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SharedWord does not support removal of elements");
        }

        @Override
        public boolean hasPrevious() {
            return this.currIdx > this.startIdx;
        }

        @Override
        public I previous() {
            return (I)this.storage[--this.currIdx];
        }

        @Override
        public int nextIndex() {
            return this.currIdx - this.startIdx;
        }

        @Override
        public int previousIndex() {
            return this.currIdx - this.startIdx - 1;
        }

        @Override
        public void set(I e) {
            throw new UnsupportedOperationException("SharedWord does not support modification");
        }

        @Override
        public void add(I e) {
            throw new UnsupportedOperationException("SharedWord does not support modification");
        }
    }
}

