/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.smartcollections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import net.automatalib.commons.smartcollections.AbstractSmartCollection;
import net.automatalib.commons.smartcollections.CapacityManagement;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.commons.smartcollections.InvalidReferenceException;
import net.automatalib.commons.smartcollections.SmartDynamicPriorityQueue;
import net.automatalib.commons.util.array.ResizingObjectArray;
import net.automatalib.commons.util.comparison.CmpUtil;

public class BinaryHeap<E>
extends AbstractSmartCollection<E>
implements SmartDynamicPriorityQueue<E>,
CapacityManagement {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private ResizingObjectArray entries;
    private int size = 0;
    private final Comparator<? super E> comparator;

    private static <E> Reference<E> asHeapRef(ElementReference ref) {
        if (ref.getClass() != Reference.class) {
            throw new InvalidReferenceException("Reference is of wrong class '" + ref.getClass().getName() + "', should be " + Reference.class.getName() + ".");
        }
        return (Reference)ref;
    }

    private static int parent(int child) {
        return child / 2;
    }

    private static int leftChild(int parent) {
        return 2 * parent;
    }

    private static int rightChild(int parent) {
        return 2 * parent + 1;
    }

    private static boolean hasParent(int idx) {
        return idx > 0;
    }

    public static <E extends Comparable<E>> BinaryHeap<E> create() {
        return new BinaryHeap<E>(10, CmpUtil.naturalOrderingComparator());
    }

    public static <E extends Comparable<E>> BinaryHeap<E> create(int initialCapacity) {
        return new BinaryHeap<E>(initialCapacity, CmpUtil.naturalOrderingComparator());
    }

    public static <E extends Comparable<E>> BinaryHeap<E> create(Collection<? extends E> initValues) {
        return new BinaryHeap<E>(0, initValues, CmpUtil.naturalOrderingComparator());
    }

    public static <E extends Comparable<E>> BinaryHeap<E> create(int initialCapacity, Collection<? extends E> initValues) {
        return new BinaryHeap<E>(initialCapacity, initValues, CmpUtil.naturalOrderingComparator());
    }

    public static <E> BinaryHeap<E> createCmp(Comparator<? super E> comparator) {
        return new BinaryHeap<E>(10, comparator);
    }

    public static <E> BinaryHeap<E> createCmp(Comparator<? super E> comparator, int initialCapacity) {
        return new BinaryHeap<E>(initialCapacity, comparator);
    }

    public static <E> BinaryHeap<E> createCmp(Comparator<? super E> comparator, Collection<? extends E> initValues) {
        return new BinaryHeap<E>(0, initValues, comparator);
    }

    public static <E> BinaryHeap<E> createCmp(Comparator<? super E> comparator, int initialCapacity, Collection<? extends E> initValues) {
        return new BinaryHeap<E>(initialCapacity, initValues, comparator);
    }

    private boolean hasChildren(int idx) {
        return idx * 2 < this.size;
    }

    private boolean hasRightChild(int idx) {
        return idx * 2 + 1 < this.size;
    }

    private void remove(int index) {
        this.forceToTop(index);
        this.extractMin();
    }

    private int compare(Reference<E> e1, Reference<E> e2) {
        return this.comparator.compare(e1.element, e2.element);
    }

    private void upHeap(int idx) {
        int pidx;
        Reference p;
        Reference e = (Reference)this.entries.array[idx];
        while (BinaryHeap.hasParent(idx) && this.compare(e, p = (Reference)this.entries.array[pidx = BinaryHeap.parent(idx)]) < 0) {
            this.entries.array[pidx] = e;
            this.entries.array[idx] = p;
            p.index = idx;
            idx = BinaryHeap.parent(idx);
        }
        e.index = idx;
    }

    private void downHeap(int idx) {
        Reference e = (Reference)this.entries.array[idx];
        while (this.hasChildren(idx)) {
            int rcidx;
            Reference rc;
            int cidx = BinaryHeap.leftChild(idx);
            Reference c = (Reference)this.entries.array[cidx];
            if (this.hasRightChild(idx) && this.compare(rc = (Reference)this.entries.array[rcidx = BinaryHeap.rightChild(idx)], c) < 0) {
                cidx = rcidx;
                c = rc;
            }
            if (this.compare(e, c) <= 0) break;
            this.entries.array[cidx] = e;
            this.entries.array[idx] = c;
            c.index = idx;
            idx = cidx;
        }
        e.index = idx;
    }

    private void forceToTop(int idx) {
        Reference e = (Reference)this.entries.array[idx];
        while (BinaryHeap.hasParent(idx)) {
            int pidx = BinaryHeap.parent(idx);
            Reference p = (Reference)this.entries.array[pidx];
            this.entries.array[pidx] = e;
            this.entries.array[idx] = p;
            p.index = idx;
            idx = BinaryHeap.parent(idx);
        }
        e.index = idx;
    }

    private void buildHeap(int numElements) {
        this.size = numElements;
        for (int i = numElements / 2; i >= 0; --i) {
            this.downHeap(i);
        }
    }

    protected BinaryHeap(int initialCapacity, Comparator<? super E> comparator) {
        this.entries = new ResizingObjectArray(initialCapacity);
        this.comparator = comparator;
    }

    protected BinaryHeap(int initCapacity, Collection<? extends E> initValues, Comparator<? super E> comparator) {
        this(initCapacity < initValues.size() ? initValues.size() : initCapacity, comparator);
        int i = 0;
        for (E e : initValues) {
            this.entries.array[i++] = new Reference<E>(0, e);
        }
        super.buildHeap(initValues.size());
    }

    @Override
    public E extractMin() {
        Object min = ((Reference)this.entries.array[0]).element;
        this.entries.array[0] = this.entries.array[--this.size];
        this.entries.array[this.size] = null;
        if (this.size > 0) {
            this.downHeap(0);
        }
        return min;
    }

    public void keyChanged(int index) {
        this.upHeap(index);
        this.downHeap(index);
    }

    @Override
    public E peekMin() {
        return ((Reference)this.entries.array[0]).element;
    }

    @Override
    public Reference<E> referencedAdd(E elem) {
        Reference<E> entry;
        this.ensureCapacity(this.size + 1);
        this.entries.array[this.size] = entry = new Reference<E>(this.size, elem);
        this.upHeap(this.size++);
        return entry;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void keyChanged(ElementReference ref) {
        this.keyChanged(BinaryHeap.asHeapRef((ElementReference)ref).index);
    }

    @Override
    public E get(ElementReference ref) {
        return BinaryHeap.asHeapRef((ElementReference)ref).element;
    }

    @Override
    public Iterator<ElementReference> referenceIterator() {
        return new ReferenceIterator();
    }

    @Override
    public void remove(ElementReference ref) {
        this.remove(BinaryHeap.asHeapRef((ElementReference)ref).index);
    }

    @Override
    public void replace(ElementReference ref, E newElement) {
        Reference<E> heapRef = BinaryHeap.asHeapRef(ref);
        heapRef.element = newElement;
        this.keyChanged(ref);
    }

    @Override
    public boolean ensureCapacity(int minCapacity) {
        return this.entries.ensureCapacity(minCapacity);
    }

    @Override
    public boolean ensureAdditionalCapacity(int additionalCapacity) {
        return this.ensureCapacity(this.size + additionalCapacity);
    }

    @Override
    public void hintNextCapacity(int nextCapacityHint) {
        this.entries.hintNextCapacity(nextCapacityHint);
    }

    @Override
    public void deepClear() {
        this.entries.setAll(null);
    }

    @Override
    public void quickClear() {
        this.size = 0;
    }

    private class ReferenceIterator
    implements Iterator<ElementReference> {
        private int current;

        private ReferenceIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < BinaryHeap.this.size;
        }

        @Override
        public ElementReference next() {
            return (ElementReference)((BinaryHeap)BinaryHeap.this).entries.array[this.current++];
        }

        @Override
        public void remove() {
            BinaryHeap.this.remove(--this.current);
        }
    }

    private static final class Reference<E>
    implements ElementReference {
        protected int index;
        protected E element;

        protected Reference(int index, E element) {
            this.element = element;
            this.index = index;
        }
    }
}

