/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util.collection;

import java.util.Iterator;
import net.automatalib.common.util.collection.AbstractTwoLevelIterator;

public abstract class AbstractThreeLevelIterator<L1, L2, L3, O>
implements Iterator<O> {
    private final InnerIterator innerIterator;

    public AbstractThreeLevelIterator(Iterator<L1> l1Iterator) {
        OuterIterator outerIterator = new OuterIterator(l1Iterator);
        this.innerIterator = new InnerIterator(outerIterator);
    }

    protected abstract Iterator<L2> l2Iterator(L1 var1);

    protected abstract Iterator<L3> l3Iterator(L1 var1, L2 var2);

    protected abstract O combine(L1 var1, L2 var2, L3 var3);

    @Override
    public boolean hasNext() {
        return this.innerIterator.hasNext();
    }

    @Override
    public O next() {
        return this.innerIterator.next();
    }

    @Override
    public void remove() {
        this.innerIterator.remove();
    }

    private class InnerIterator
    extends AbstractTwoLevelIterator<Outer<L1, L2>, L3, O> {
        InnerIterator(Iterator<Outer<L1, L2>> outerIterator) {
            super(outerIterator);
        }

        @Override
        protected Iterator<L3> l2Iterator(Outer<L1, L2> outer) {
            return AbstractThreeLevelIterator.this.l3Iterator(outer.l1Item, outer.l2Item);
        }

        @Override
        protected O combine(Outer<L1, L2> outer, L3 l3Object) {
            return AbstractThreeLevelIterator.this.combine(outer.l1Item, outer.l2Item, l3Object);
        }
    }

    private class OuterIterator
    extends AbstractTwoLevelIterator<L1, L2, Outer<L1, L2>> {
        private final Outer<L1, L2> value;

        OuterIterator(Iterator<L1> l1Iterator) {
            super(l1Iterator);
            this.value = new Outer();
        }

        @Override
        protected Iterator<L2> l2Iterator(L1 l1Object) {
            return AbstractThreeLevelIterator.this.l2Iterator(l1Object);
        }

        @Override
        protected Outer<L1, L2> combine(L1 l1Object, L2 l2Object) {
            this.value.l1Item = l1Object;
            this.value.l2Item = l2Object;
            return this.value;
        }
    }

    private static class Outer<L1, L2> {
        private L1 l1Item;
        private L2 l2Item;

        private Outer() {
        }
    }
}

