/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public abstract class IOUtil {
    public static void skip(InputStream is) throws IOException {
        while (is.available() > 0) {
            is.skip(Long.MAX_VALUE);
        }
        is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, OutputStream os, boolean close) throws IOException {
        byte[] buf = new byte[8192];
        try {
            int len;
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        }
        finally {
            if (close) {
                try {
                    is.close();
                }
                catch (IOException e) {}
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        IOUtil.copy(is, os, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader r, Writer w, boolean close) throws IOException {
        char[] buf = new char[8192];
        try {
            int len;
            while ((len = r.read(buf)) != -1) {
                w.write(buf, 0, len);
            }
        }
        finally {
            if (close) {
                try {
                    r.close();
                }
                catch (IOException e) {}
                try {
                    w.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void copy(Reader r, Writer w) throws IOException {
        IOUtil.copy(r, w, true);
    }
}

