/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util;

public final class UnionFind {
    private final int[] p;
    private final int[] rank;

    public UnionFind(int n) {
        this.p = new int[n];
        this.rank = new int[n];
        for (int i = 0; i < n; ++i) {
            this.p[i] = i;
        }
    }

    public int union(int p, int q) {
        return this.link(this.find(p), this.find(q));
    }

    public int link(int x, int y) {
        if (this.rank[x] > this.rank[y]) {
            this.p[y] = x;
            return x;
        }
        this.p[x] = y;
        if (this.rank[x] == this.rank[y]) {
            int n = y;
            this.rank[n] = this.rank[n] + 1;
        }
        return y;
    }

    public int find(int x) {
        int r = this.p[x];
        if (x != r) {
            this.p[x] = r = this.find(r);
        }
        return r;
    }
}

