/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import net.automatalib.commons.util.collections.AllCombinationsIterator;
import net.automatalib.commons.util.collections.AllTuplesIterator;
import net.automatalib.commons.util.collections.CharRange;
import net.automatalib.commons.util.collections.IntRange;
import net.automatalib.commons.util.collections.NullList;

public abstract class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static <E> boolean addAll(Collection<E> coll, Iterable<? extends E> it) {
        boolean modified = false;
        for (E e : it) {
            modified = coll.add(e) || modified;
        }
        return modified;
    }

    public static <E> List<E> nullList(int size) {
        return new NullList(size);
    }

    public static <E> E removeReplace(List<E> list, int index) {
        int lastIdx = list.size() - 1;
        E last = list.remove(lastIdx);
        if (lastIdx != index) {
            list.set(index, last);
            return last;
        }
        return null;
    }

    public static List<Integer> intRange(int start, int end) {
        return new IntRange(start, end);
    }

    public static List<Integer> intRange(int start, int end, int step) {
        return new IntRange(start, end, step);
    }

    public static List<Character> charRange(char start, char end) {
        return new CharRange(start, end);
    }

    public static <T> List<? extends T> randomAccessList(Collection<? extends T> coll) {
        if (coll instanceof List && coll instanceof RandomAccess) {
            return (List)coll;
        }
        return new ArrayList<T>(coll);
    }

    public static <T> Iterable<List<T>> allTuples(final Iterable<T> domain, final int minLength, final int maxLength) {
        if (!domain.iterator().hasNext()) {
            if (minLength == 0) {
                return Collections.singletonList(Collections.emptyList());
            }
            return Collections.emptyList();
        }
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new AllTuplesIterator(domain, minLength, maxLength);
            }
        };
    }

    public static <T> Iterable<List<T>> allTuples(Iterable<T> domain, int length) {
        return CollectionsUtil.allTuples(domain, length, length);
    }

    @SafeVarargs
    public static <T> Iterable<List<T>> allCombinations(final Iterable<T> ... iterables) {
        if (iterables.length == 0) {
            return Collections.singletonList(Collections.emptyList());
        }
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                try {
                    return new AllCombinationsIterator(iterables);
                }
                catch (NoSuchElementException ex) {
                    return Collections.emptySet().iterator();
                }
            }
        };
    }
}

