/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.comparison;

import java.util.Comparator;
import java.util.Iterator;
import net.automatalib.commons.util.comparison.LexComparator;
import net.automatalib.commons.util.comparison.NaturalLexComparator;
import net.automatalib.commons.util.comparison.NaturalOrderingComparator;
import net.automatalib.commons.util.comparison.SafeComparator;

public abstract class CmpUtil {
    private CmpUtil() {
    }

    public static <U> int lexCompare(Iterable<? extends U> o1, Iterable<? extends U> o2, Comparator<U> elemComparator) {
        Iterator<U> it1 = o1.iterator();
        Iterator<U> it2 = o2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            int cmp = elemComparator.compare(it1.next(), it2.next());
            if (cmp == 0) continue;
            return cmp;
        }
        if (it1.hasNext()) {
            return 1;
        }
        if (it2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <U extends Comparable<? super U>> int lexCompare(Iterable<? extends U> o1, Iterable<? extends U> o2) {
        Iterator<U> it1 = o1.iterator();
        Iterator<U> it2 = o2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            int cmp = ((Comparable)it1.next()).compareTo(it2.next());
            if (cmp == 0) continue;
            return cmp;
        }
        if (it1.hasNext()) {
            return 1;
        }
        if (it2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <T extends Iterable<U>, U> Comparator<T> lexComparator(Comparator<U> elemComp) {
        return new LexComparator(elemComp);
    }

    public static <U extends Comparable<U>, T extends Iterable<U>> Comparator<T> lexComparator() {
        return NaturalLexComparator.getInstance();
    }

    public static <T> Comparator<T> safeComparator(Comparator<T> baseComp, NullOrdering nullOrd) {
        return new SafeComparator<T>(baseComp, nullOrd);
    }

    public static <T extends Comparable<T>> Comparator<T> naturalOrderingComparator() {
        return NaturalOrderingComparator.getInstance();
    }

    public static enum NullOrdering {
        MIN(-1),
        MAX(1);

        public final int firstNullResult;

        private NullOrdering(int firstNullResult) {
            this.firstNullResult = firstNullResult;
        }
    }
}

