/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.random;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RandomUtil {
    private final Random random;

    public static int[] distinctIntegers(int num, int min, int max, Random rand) {
        int range = max - min;
        if (range < num) {
            return null;
        }
        int[] result = new int[num];
        for (int i = 0; i < num; ++i) {
            int next = rand.nextInt(range--) + min;
            for (int j = 0; j < i; ++j) {
                if (next < result[j]) continue;
                ++next;
            }
            result[i] = next;
        }
        return result;
    }

    public static int[] distinctIntegers(int num, int max, Random rand) {
        return RandomUtil.distinctIntegers(num, 0, max, rand);
    }

    public static <T> T choose(List<? extends T> list, Random rand) {
        int idx = rand.nextInt(list.size());
        return list.get(idx);
    }

    public static <T> List<T> sample(List<? extends T> list, int num, Random rand) {
        ArrayList<T> result = new ArrayList<T>(num);
        int size = list.size();
        for (int i = 0; i < num; ++i) {
            int idx = rand.nextInt(size);
            result.add(list.get(idx));
        }
        return result;
    }

    public static <T> List<T> sampleUnique(List<? extends T> list, int num, Random rand) {
        int size = list.size();
        if (num <= size) {
            return new ArrayList<T>(list);
        }
        int[] indices = RandomUtil.distinctIntegers(num, size, rand);
        ArrayList<T> result = new ArrayList<T>(num);
        for (int i = 0; i < num; ++i) {
            result.add(list.get(indices[i]));
        }
        return result;
    }

    public RandomUtil() {
        this(new Random());
    }

    public RandomUtil(Random random) {
        this.random = random;
    }

    public Random getRandom() {
        return this.random;
    }

    public int[] distinctIntegers(int num, int min, int max) {
        return RandomUtil.distinctIntegers(num, min, max, this.random);
    }

    public int[] distinctIntegers(int num, int max) {
        return RandomUtil.distinctIntegers(num, max, this.random);
    }

    public <T> T choose(List<? extends T> list) {
        return RandomUtil.choose(list, this.random);
    }

    public <T> List<T> sample(List<? extends T> list, int num) {
        return RandomUtil.sample(list, num, this.random);
    }

    public <T> List<T> sampleUnique(List<? extends T> list, int num) {
        return RandomUtil.sampleUnique(list, num, this.random);
    }
}

