/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.strings;

import java.io.IOException;

public class StringIndexGenerator {
    private final char base;

    private char getChar(int idx) {
        return (char)(this.base + idx);
    }

    private static int getInteger(char c) {
        c = Character.toLowerCase(c);
        return c - 97;
    }

    public StringIndexGenerator(Case charCase) {
        switch (charCase) {
            case LOWER: {
                this.base = (char)97;
                break;
            }
            default: {
                this.base = (char)65;
            }
        }
    }

    public void appendStringIndex(Appendable a, int idx) throws IOException {
        do {
            a.append(this.getChar(idx % 26));
        } while ((idx /= 26) > 0);
    }

    public void appendStringIndex(StringBuilder sb, int idx) {
        do {
            sb.append(this.getChar(idx % 26));
        } while ((idx /= 26) > 0);
    }

    public String getStringIndex(int idx) {
        StringBuilder sb = new StringBuilder();
        this.appendStringIndex(sb, idx);
        return sb.toString();
    }

    public static int getIntegerIndex(String sidx) {
        int idx = 0;
        int value = 1;
        for (int i = 0; i < sidx.length(); ++i) {
            char c = sidx.charAt(i);
            idx += value * StringIndexGenerator.getInteger(c);
            value *= 26;
        }
        return idx;
    }

    public static enum Case {
        LOWER,
        UPPER;

    }
}

