/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util;

public final class UnionFind {
    private final int[] p;
    private final int[] rank;

    public UnionFind(int n) {
        this.p = new int[n];
        this.rank = new int[n];
        for (int i = 0; i < n; ++i) {
            this.p[i] = i;
        }
    }

    public int size() {
        return this.p.length;
    }

    public int union(int p, int q) {
        return this.link(this.find(p), this.find(q));
    }

    public int link(int x, int y) {
        int rx = this.rank[x];
        int ry = this.rank[y];
        if (rx > ry) {
            this.p[y] = x;
            return x;
        }
        this.p[x] = y;
        if (rx == ry) {
            this.rank[y] = ry + 1;
        }
        return y;
    }

    public int find(int x) {
        int curr = x;
        int currp = this.p[curr];
        while (curr != currp) {
            curr = currp;
            currp = this.p[curr];
        }
        int ancestor = curr;
        curr = x;
        while (curr != ancestor) {
            int next = this.p[curr];
            this.p[curr] = ancestor;
            curr = next;
        }
        return ancestor;
    }
}

