/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.array;

import java.util.Arrays;
import net.automatalib.commons.util.array.ArrayWritable;

public abstract class AWUtil {
    private AWUtil() {
    }

    public static <T, U extends T> int safeWrite(ArrayWritable<U> aw, T[] array) {
        int num = aw.size();
        if (num <= 0) {
            return 0;
        }
        if (num > array.length) {
            num = array.length;
        }
        aw.writeToArray(0, array, 0, num);
        return num;
    }

    public static <T, U extends T> int safeWrite(int num, ArrayWritable<U> aw, T[] array) {
        int tmp = aw.size();
        if (tmp < num) {
            num = tmp;
        }
        if ((tmp = array.length) < num) {
            num = tmp;
        }
        if (num <= 0) {
            return 0;
        }
        aw.writeToArray(0, array, 0, num);
        return num;
    }

    public static <T, U extends T> int safeWrite(int num, ArrayWritable<U> aw, int ofs, T[] array, int tgtOfs) {
        int tmp = aw.size() - ofs;
        if (tmp < num) {
            num = tmp;
        }
        if ((tmp = array.length - tgtOfs) < num) {
            num = tmp;
        }
        if (num <= 0) {
            return 0;
        }
        aw.writeToArray(ofs, array, tgtOfs, num);
        return num;
    }

    public static <T, U extends T> int safeWrite(ArrayWritable<U> aw, T[] array, int tgtOfs) {
        int num = array.length - tgtOfs;
        int s = aw.size();
        if (s < num) {
            num = s;
        }
        if (num <= 0) {
            return 0;
        }
        aw.writeToArray(0, array, tgtOfs, num);
        return num;
    }

    public static Object[] toArray(ArrayWritable<?> aw) {
        int num = aw.size();
        Object[] arr = new Object[num];
        aw.writeToArray(0, arr, 0, num);
        return arr;
    }

    public static <T> T[] toArray(ArrayWritable<?> aw, T[] arr) {
        int num = aw.size();
        if (arr.length < num) {
            arr = Arrays.copyOf(arr, num);
        }
        aw.writeToArray(0, arr, 0, num);
        return arr;
    }
}

