/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.automatalib.commons.util.collections.ConcatIterator;
import net.automatalib.commons.util.collections.UnmodifiableIterator;

public abstract class IterableUtil {
    private static final Iterator<?> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    @SafeVarargs
    public static <T> Iterator<T> concat(Iterator<? extends T> ... iterators) {
        return new ConcatIterator<T>(iterators);
    }

    @SafeVarargs
    public static <T> Iterable<T> concat(final Iterable<? extends T> ... iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Iterator[] iterators = new Iterator[iterables.length];
                for (int i = 0; i < iterables.length; ++i) {
                    iterators[i] = iterables[i].iterator();
                }
                return IterableUtil.concat(iterators);
            }
        };
    }

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> Iterator<T> unmodifiableIterator(Iterator<T> iterator) {
        return new UnmodifiableIterator<T>(iterator);
    }

    public static <T> Iterable<T> unmodifiableIterable(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return IterableUtil.unmodifiableIterator(iterable.iterator());
            }
        };
    }

    public static <T> Iterator<List<T>> allCombinationsIterator(List<? extends Iterable<? extends T>> iterables) {
        return IterableUtil.allCombinationsIterator(iterables);
    }

    @SafeVarargs
    public static <T> Iterator<List<T>> allCombinationsIterator(Iterable<? extends T> ... iterables) {
        return IterableUtil.allCombinationsIterator(Arrays.asList(iterables));
    }

    public static <T> Iterable<List<T>> allCombinations(final List<? extends Iterable<? extends T>> iterables) {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return IterableUtil.allCombinationsIterator(iterables);
            }
        };
    }

    @SafeVarargs
    public static <T> Iterable<List<T>> allCombinations(Iterable<? extends T> ... iterables) {
        return IterableUtil.allCombinations(Arrays.asList(iterables));
    }

    private IterableUtil() {
    }
}

