/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.nid;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.automatalib.commons.util.nid.IDChangeListener;
import net.automatalib.commons.util.nid.NumericID;
import net.automatalib.commons.util.ref.Ref;
import net.automatalib.commons.util.ref.StrongRef;
import net.automatalib.commons.util.ref.WeakRef;

public class IDChangeNotifier<T extends NumericID> {
    private final List<Ref<IDChangeListener<T>>> listeners = new LinkedList<Ref<IDChangeListener<T>>>();

    public void addListener(IDChangeListener<T> listener, boolean weak) {
        Ref<IDChangeListener<T>> ref = weak ? new WeakRef<IDChangeListener<T>>(listener) : new StrongRef<IDChangeListener<T>>(listener);
        this.listeners.add(ref);
    }

    public void removeListener(IDChangeListener<T> listener) {
        if (listener == null) {
            return;
        }
        Iterator<Ref<IDChangeListener<T>>> it = this.listeners.iterator();
        while (it.hasNext()) {
            IDChangeListener<T> referent = it.next().get();
            if (referent == null) {
                it.remove();
                continue;
            }
            if (!referent.equals(listener)) continue;
            it.remove();
        }
    }

    public void notifyListeners(T obj, int newId, int oldId) {
        Iterator<Ref<IDChangeListener<T>>> it = this.listeners.iterator();
        while (it.hasNext()) {
            IDChangeListener<T> listener = it.next().get();
            if (listener == null) {
                it.remove();
                continue;
            }
            listener.idChanged(obj, newId, oldId);
        }
    }
}

