/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import net.automatalib.commons.util.settings.SettingsSource;

public class LocalFileSource
implements SettingsSource {
    private final File file;

    protected LocalFileSource(File file) {
        this.file = file;
    }

    protected LocalFileSource(String fileName) {
        this(new File(fileName));
    }

    @Override
    public int getPriority() {
        return 0x7FFFFFFE;
    }

    @Override
    public void loadSettings(Properties properties) {
        if (!this.file.exists()) {
            return;
        }
        Logger log = Logger.getLogger(this.getClass().getName());
        try (BufferedReader r = new BufferedReader(new FileReader(this.file));){
            properties.load(r);
        }
        catch (IOException ex) {
            log.warning("Could not read properties file " + this.file.getAbsolutePath() + ": " + ex.getMessage());
        }
    }
}

