/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base;

import net.automatalib.automata.Automaton;
import net.automatalib.commons.util.array.ResizingObjectArray;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.nid.IDChangeListener;
import net.automatalib.commons.util.nid.NumericID;

public class StateIDDynamicMapping<S extends NumericID, V>
implements MutableMapping<S, V>,
IDChangeListener<S> {
    private final Automaton<S, ?, ?> automaton;
    private final ResizingObjectArray storage;

    public StateIDDynamicMapping(Automaton<S, ?, ?> automaton) {
        this.automaton = automaton;
        this.storage = new ResizingObjectArray(automaton.size());
    }

    public V get(S elem) {
        int id = elem.getId();
        if (id < this.storage.array.length) {
            return (V)this.storage.array[id];
        }
        return null;
    }

    public void idChanged(S obj, int newId, int oldId) {
        Object oldValue = null;
        if (oldId > 0 && oldId < this.storage.array.length) {
            oldValue = this.storage.array[oldId];
            this.storage.array[oldId] = null;
        }
        if (newId >= this.storage.array.length) {
            this.storage.ensureCapacity(this.automaton.size());
        }
        this.storage.array[newId] = oldValue;
    }

    public V put(S key, V value) {
        int id = key.getId();
        if (id >= this.storage.array.length) {
            this.storage.ensureCapacity(this.automaton.size());
        }
        Object old = this.storage.array[id];
        this.storage.array[id] = value;
        return (V)old;
    }
}

