/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.fast;

import java.util.Collection;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.automata.ShrinkableAutomaton;
import net.automatalib.automata.ShrinkableDeterministic;
import net.automatalib.automata.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automata.base.StateIDDynamicMapping;
import net.automatalib.automata.base.fast.FastDetState;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.helpers.StateIDStaticMapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.nid.DynamicList;
import net.automatalib.commons.util.nid.IDChangeNotifier;
import net.automatalib.words.Alphabet;

public abstract class FastMutableDet<S extends FastDetState<S, T>, I, T, SP, TP>
implements ShrinkableDeterministic<S, I, T, SP, TP>,
UniversalFiniteAlphabetAutomaton<S, I, T, SP, TP>,
StateIDs<S> {
    private final DynamicList<S> states = new DynamicList();
    private final IDChangeNotifier<S> tracker = new IDChangeNotifier();
    private S initialState;
    protected final Alphabet<I> inputAlphabet;

    public FastMutableDet(Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
    }

    public Collection<S> getStates() {
        return this.states;
    }

    public S getState(int id) {
        return (S)((Object)((FastDetState)this.states.get(id)));
    }

    public int getStateId(S state) {
        return state.getId();
    }

    public void setInitialState(S state) {
        this.initialState = state;
    }

    public void setTransition(S state, I input, T transition) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        ((FastDetState)((Object)state)).setTransition(inputIdx, transition);
    }

    public S getInitialState() {
        return this.initialState;
    }

    public T getTransition(S state, I input) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        return ((FastDetState)((Object)state)).getTransition(inputIdx);
    }

    public void clear() {
        this.states.clear();
        this.initialState = null;
    }

    public S addState(SP property) {
        S newState = this.createState(property);
        this.states.add(newState);
        return newState;
    }

    public void removeState(S state, S replacement) {
        ShrinkableAutomaton.unlinkState((MutableAutomaton)this, state, replacement, this.inputAlphabet);
        this.states.remove(state);
    }

    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    public void removeAllTransitions(S state) {
        ((FastDetState)((Object)state)).clearTransitions();
    }

    public StateIDs<S> stateIDs() {
        return this;
    }

    public <V> MutableMapping<S, V> createStaticStateMapping() {
        return new StateIDStaticMapping((StateIDs)this, this.size());
    }

    public <V> MutableMapping<S, V> createDynamicStateMapping() {
        StateIDDynamicMapping mapping = new StateIDDynamicMapping(this);
        this.tracker.addListener(mapping, true);
        return mapping;
    }

    protected abstract S createState(SP var1);
}

