/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.fsa.impl.compact;

import java.util.BitSet;
import net.automatalib.automata.AutomatonCreator;
import net.automatalib.automata.base.compact.AbstractCompactSimpleNondet;
import net.automatalib.automata.fsa.MutableNFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.words.Alphabet;

public class CompactNFA<I>
extends AbstractCompactSimpleNondet<I, Boolean>
implements MutableNFA<Integer, I> {
    private final BitSet accepting;

    public CompactNFA(Alphabet<I> alphabet, float resizeFactor) {
        super(alphabet, resizeFactor);
        this.accepting = new BitSet();
    }

    public CompactNFA(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
        this.accepting = new BitSet();
    }

    public CompactNFA(Alphabet<I> alphabet, int stateCapacity) {
        super(alphabet, stateCapacity);
        this.accepting = new BitSet();
    }

    public CompactNFA(Alphabet<I> alphabet) {
        super(alphabet);
        this.accepting = new BitSet();
    }

    protected CompactNFA(Alphabet<I> alphabet, CompactNFA<?> other) {
        super(alphabet, other);
        this.accepting = (BitSet)other.accepting.clone();
    }

    public <I2> CompactNFA<I2> translate(Alphabet<I2> newAlphabet) {
        if (this.alphabet.size() != newAlphabet.size()) {
            throw new IllegalArgumentException("Can only translate automata with matching alphabet sizes, found: " + newAlphabet.size() + " (new) vs. " + this.alphabetSize + " (old)");
        }
        return new CompactNFA<I2>(newAlphabet, this);
    }

    public boolean isAccepting(Integer state) {
        return this.isAccepting((int)state);
    }

    public boolean isAccepting(int stateId) {
        return this.accepting.get(stateId);
    }

    @Override
    public Integer addState(boolean accepting) {
        return this.addState((Object)accepting);
    }

    public Integer addInitialState(boolean accepting) {
        return (Integer)super.addInitialState((Object)accepting);
    }

    public void setAccepting(Integer state, boolean accepting) {
        this.setAccepting(state, accepting);
    }

    public void setAccepting(int stateId, boolean accepting) {
        this.accepting.set(stateId);
    }

    public void flipAcceptance() {
        this.accepting.flip(0, this.size());
    }

    @Override
    public Boolean getStateProperty(int stateId) {
        return this.isAccepting(stateId);
    }

    @Override
    protected void initState(int stateId, Boolean property) {
        boolean bval = property != null ? property : false;
        this.accepting.set(stateId, bval);
    }

    @Override
    public void setStateProperty(int stateId, Boolean property) {
        this.setAccepting(stateId, property != null ? property : false);
    }

    @Override
    public void clear() {
        this.accepting.clear(0, this.size());
        super.clear();
    }

    public CompactDFA<I> determinize() {
        return null;
    }

    public static final class Creator<I>
    implements AutomatonCreator<CompactNFA<I>, I> {
        public CompactNFA<I> createAutomaton(Alphabet<I> alphabet) {
            return new CompactNFA<I>(alphabet);
        }

        public CompactNFA<I> createAutomaton(Alphabet<I> alphabet, int numStates) {
            return new CompactNFA<I>(alphabet, numStates);
        }
    }
}

