/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs.base.compact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.automatalib.commons.util.array.ResizingObjectArray;
import net.automatalib.graphs.BidirectionalGraph;
import net.automatalib.graphs.base.compact.AbstractCompactSimpleGraph;
import net.automatalib.graphs.base.compact.CompactBidiEdge;

public class CompactSimpleBidiGraph<EP>
extends AbstractCompactSimpleGraph<CompactBidiEdge<EP>, EP>
implements BidirectionalGraph<Integer, CompactBidiEdge<EP>> {
    private final ResizingObjectArray inEdges;

    public CompactSimpleBidiGraph() {
        this.inEdges = new ResizingObjectArray();
    }

    public CompactSimpleBidiGraph(int initialCapacity) {
        super(initialCapacity);
        this.inEdges = new ResizingObjectArray(initialCapacity);
    }

    protected List<CompactBidiEdge<EP>> getInEdgeList(int node) {
        return (List)this.inEdges.array[node];
    }

    @Override
    protected CompactBidiEdge<EP> createEdge(int source, int target, EP property) {
        return new CompactBidiEdge<EP>(source, target, property);
    }

    public Collection<CompactBidiEdge<EP>> getIncomingEdges(Integer node) {
        return this.getIncomingEdges((int)node);
    }

    public Collection<CompactBidiEdge<EP>> getIncomingEdges(int node) {
        List<CompactBidiEdge<EP>> inEdges = this.getInEdgeList(node);
        return Collections.unmodifiableCollection(inEdges);
    }

    public Integer getSource(CompactBidiEdge<EP> edge) {
        return this.getIntSource(edge);
    }

    public int getIntSource(CompactBidiEdge<EP> edge) {
        return edge.getSource();
    }

    @Override
    public int addIntNode(Void properties) {
        this.inEdges.ensureCapacity(this.size + 1);
        int node = super.addIntNode(properties);
        this.inEdges.array[node] = new ArrayList();
        return node;
    }

    @Override
    public CompactBidiEdge<EP> connect(int source, int target, EP property) {
        CompactBidiEdge edge = (CompactBidiEdge)super.connect(source, target, property);
        List<CompactBidiEdge<EP>> inEdges = this.getInEdgeList(source);
        edge.inIndex = inEdges.size();
        inEdges.add(edge);
        return edge;
    }
}

