/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import net.automatalib.visualization.DummyVP;
import net.automatalib.visualization.VisualizationProvider;

public class VPManager {
    private final Map<String, VisualizationProvider> providers = new HashMap<String, VisualizationProvider>();
    private VisualizationProvider bestProvider = new DummyVP();

    public void load() {
        this.providers.clear();
        ServiceLoader<VisualizationProvider> loader = ServiceLoader.load(VisualizationProvider.class);
        this.bestProvider = new DummyVP();
        for (VisualizationProvider vp : loader) {
            this.registerProvider(vp);
        }
    }

    public void registerProvider(VisualizationProvider vp) {
        if (!vp.checkUsable()) {
            return;
        }
        this.providers.put(vp.getId(), vp);
        if (vp.getPriority() > this.bestProvider.getPriority()) {
            this.bestProvider = vp;
        }
    }

    public VisualizationProvider getBestProvider() {
        return this.bestProvider;
    }

    public VisualizationProvider getProviderByName(String name) {
        return this.providers.get(name);
    }
}

