/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa.dag;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.UniversalAutomaton;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.automaton.graph.UniversalAutomatonGraphView;
import net.automatalib.common.util.UnionFind;
import net.automatalib.graph.Graph;
import net.automatalib.incremental.dfa.AbstractIncrementalDFABuilder;
import net.automatalib.incremental.dfa.AbstractVisualizationHelper;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.dag.State;
import net.automatalib.incremental.dfa.dag.StateSignature;
import net.automatalib.ts.UniversalDTS;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractIncrementalDFADAGBuilder<I>
extends AbstractIncrementalDFABuilder<I> {
    final Map<StateSignature, State> register = new LinkedHashMap<StateSignature, State>();
    final State init;
    State sink;

    AbstractIncrementalDFADAGBuilder(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
        StateSignature sig = new StateSignature(this.alphabetSize, Acceptance.DONT_KNOW);
        this.init = new State(sig);
        this.register.put(sig, this.init);
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        int oldSize = this.alphabetSize;
        super.addAlphabetSymbol(symbol);
        int newSize = this.alphabetSize;
        if (oldSize < newSize) {
            this.register.values().forEach(n -> n.ensureInputCapacity(newSize));
        }
    }

    @Override
    public @Nullable Word<I> findSeparatingWord(DFA<?, I> target, Collection<? extends I> inputs, boolean omitUndefined) {
        return this.doFindSeparatingWord(target, inputs, omitUndefined);
    }

    private <S> @Nullable Word<I> doFindSeparatingWord(DFA<S, I> target, Collection<? extends I> inputs, boolean omitUndefined) {
        Record current;
        boolean acc;
        Object init2;
        int thisStates = this.register.size();
        HashMap<State, Integer> stateIds = new HashMap<State, Integer>();
        if (this.sink != null) {
            stateIds.put(this.sink, 0);
            ++thisStates;
        }
        int targetStates = target.size();
        if (!omitUndefined) {
            ++targetStates;
        }
        if ((init2 = target.getInitialState()) == null && omitUndefined) {
            return null;
        }
        State init1 = this.init;
        boolean bl = acc = init2 != null && target.isAccepting(init2);
        if (init1.getAcceptance().conflicts(acc)) {
            return Word.epsilon();
        }
        UnionFind uf = new UnionFind(thisStates + targetStates);
        StateIDs tgtIds = target.stateIDs();
        int id1 = AbstractIncrementalDFADAGBuilder.getStateId(init1, stateIds);
        int id2 = (init2 != null ? tgtIds.getStateId(init2) : targetStates - 1) + thisStates;
        uf.link(id1, id2);
        ArrayDeque<Record<@Nullable Object, I>> queue = new ArrayDeque<Record<Object, I>>();
        queue.add(new Record(init1, init2));
        Object lastSym = null;
        block0: while ((current = (Record)queue.poll()) != null) {
            State state1 = current.state1;
            @Nullable S state2 = current.state2;
            for (I sym : inputs) {
                int r2;
                State succ1;
                Object succ2;
                Object object = succ2 = state2 != null ? target.getSuccessor(state2, sym) : null;
                if (succ2 == null && omitUndefined) continue;
                int idx = this.inputAlphabet.getSymbolIndex(sym);
                State state = succ1 = state1 != this.sink ? state1.getSuccessor(idx) : this.sink;
                if (succ1 == null) continue;
                id1 = AbstractIncrementalDFADAGBuilder.getStateId(succ1, stateIds);
                id2 = (succ2 != null ? tgtIds.getStateId(succ2) : targetStates - 1) + thisStates;
                int r1 = uf.find(id1);
                if (r1 == (r2 = uf.find(id2))) continue;
                if (succ1 == this.sink) {
                    if (succ2 == null) continue;
                    if (target.isAccepting(succ2)) {
                        lastSym = sym;
                        break block0;
                    }
                } else {
                    boolean succ2acc;
                    boolean bl2 = succ2acc = succ2 != null && target.isAccepting(succ2);
                    if (succ1.getAcceptance().conflicts(succ2acc)) {
                        lastSym = sym;
                        break block0;
                    }
                }
                uf.link(r1, r2);
                queue.add(new Record<Object, I>(succ1, succ2, sym, current));
            }
        }
        if (current == null) {
            return null;
        }
        int ceLength = current.depth;
        if (lastSym != null) {
            ++ceLength;
        }
        WordBuilder wb = new WordBuilder(null, ceLength);
        int index = ceLength;
        if (lastSym != null) {
            wb.setSymbol(--index, lastSym);
        }
        while (current.reachedFrom != null) {
            Object reachedVia = current.reachedVia;
            wb.setSymbol(--index, reachedVia);
            current = current.reachedFrom;
        }
        return wb.toWord();
    }

    private static int getStateId(State s, Map<State, Integer> idMap) {
        Integer id = idMap.get(s);
        if (id != null) {
            return id;
        }
        id = idMap.size();
        idMap.put(s, id);
        return id;
    }

    abstract @Nullable State getState(Word<? extends I> var1);

    void updateInitSignature(Acceptance acc) {
        StateSignature sig = this.init.getSignature();
        sig.acceptance = acc;
    }

    void updateInitSignature(int idx, State succ) {
        StateSignature sig = this.init.getSignature();
        State oldSucc = ((State[])sig.successors.array)[idx];
        if (oldSucc == succ) {
            return;
        }
        if (oldSucc != null) {
            oldSucc.decreaseIncoming();
        }
        ((State[])sig.successors.array)[idx] = succ;
        succ.increaseIncoming();
    }

    void updateInitSignature(Acceptance acc, int idx, State succ) {
        StateSignature sig = this.init.getSignature();
        State oldSucc = ((State[])sig.successors.array)[idx];
        Acceptance oldAcc = sig.acceptance;
        if (oldSucc == succ && oldAcc == acc) {
            return;
        }
        if (oldSucc != null) {
            oldSucc.decreaseIncoming();
        }
        ((State[])sig.successors.array)[idx] = succ;
        succ.increaseIncoming();
        sig.acceptance = acc;
    }

    State updateSignature(State state, Acceptance acc) {
        assert (state != this.init);
        StateSignature sig = state.getSignature();
        if (sig.acceptance == acc) {
            return state;
        }
        this.register.remove(sig);
        sig.acceptance = acc;
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    State updateSignature(State state, int idx, State succ) {
        assert (state != this.init);
        StateSignature sig = state.getSignature();
        if (((State[])sig.successors.array)[idx] == succ) {
            return state;
        }
        this.register.remove(sig);
        if (((State[])sig.successors.array)[idx] != null) {
            ((State[])sig.successors.array)[idx].decreaseIncoming();
        }
        ((State[])sig.successors.array)[idx] = succ;
        succ.increaseIncoming();
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    State updateSignature(State state, Acceptance acc, int idx, State succ) {
        assert (state != this.init);
        StateSignature sig = state.getSignature();
        if (((State[])sig.successors.array)[idx] == succ && sig.acceptance == acc) {
            return state;
        }
        this.register.remove(sig);
        ((State[])sig.successors.array)[idx] = succ;
        sig.acceptance = acc;
        succ.increaseIncoming();
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    State replaceOrRegister(State state) {
        StateSignature sig = state.getSignature();
        State other = this.register.get(sig);
        if (other != null) {
            if (state != other) {
                for (int i = 0; i < ((State[])sig.successors.array).length; ++i) {
                    State succ = ((State[])sig.successors.array)[i];
                    if (succ == null) continue;
                    succ.decreaseIncoming();
                }
            }
            return other;
        }
        this.register.put(sig, state);
        return state;
    }

    State replaceOrRegister(StateSignature sig) {
        State state = this.register.get(sig);
        if (state != null) {
            return state;
        }
        state = new State(sig);
        this.register.put(sig, state);
        for (int i = 0; i < ((State[])sig.successors.array).length; ++i) {
            State succ = ((State[])sig.successors.array)[i];
            if (succ == null) continue;
            succ.increaseIncoming();
        }
        return state;
    }

    State hiddenClone(State other) {
        assert (other != this.init);
        StateSignature sig = other.getSignature().duplicate();
        for (int i = 0; i < this.alphabetSize; ++i) {
            State succ = ((State[])sig.successors.array)[i];
            if (succ == null) continue;
            succ.increaseIncoming();
        }
        return new State(sig);
    }

    void hide(State state) {
        assert (state != this.init);
        StateSignature sig = state.getSignature();
        this.register.remove(sig);
    }

    State unhide(State state, Acceptance acc, int idx, State succ) {
        assert (state != this.init);
        StateSignature sig = state.getSignature();
        sig.acceptance = acc;
        State prevSucc = ((State[])sig.successors.array)[idx];
        if (prevSucc != null) {
            prevSucc.decreaseIncoming();
        }
        ((State[])sig.successors.array)[idx] = succ;
        if (succ != null) {
            succ.increaseIncoming();
        }
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    State unhide(State state, int idx, State succ) {
        assert (state != this.init);
        StateSignature sig = state.getSignature();
        State prevSucc = ((State[])sig.successors.array)[idx];
        if (prevSucc != null) {
            prevSucc.decreaseIncoming();
        }
        ((State[])sig.successors.array)[idx] = succ;
        if (succ != null) {
            succ.increaseIncoming();
        }
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    State clone(State other, Acceptance acc) {
        assert (other != this.init);
        StateSignature sig = other.getSignature();
        if (sig.acceptance == acc) {
            return other;
        }
        sig = sig.duplicate();
        sig.acceptance = acc;
        sig.updateHashCode();
        return this.replaceOrRegister(sig);
    }

    State clone(State other, int idx, State succ) {
        assert (other != this.init);
        StateSignature sig = other.getSignature();
        if (((State[])sig.successors.array)[idx] == succ) {
            return other;
        }
        sig = sig.duplicate();
        ((State[])sig.successors.array)[idx] = succ;
        sig.updateHashCode();
        return this.replaceOrRegister(sig);
    }

    State clone(State other, Acceptance acc, int idx, State succ) {
        assert (other != this.init);
        StateSignature sig = other.getSignature();
        if (((State[])sig.successors.array)[idx] == succ && sig.acceptance == acc) {
            return other;
        }
        sig = sig.duplicate();
        ((State[])sig.successors.array)[idx] = succ;
        sig.acceptance = acc;
        return this.replaceOrRegister(sig);
    }

    @Override
    public UniversalDTS<?, I, ?, Acceptance, Void> asTransitionSystem() {
        return new TransitionSystemView();
    }

    @Override
    public Graph<?, ?> asGraph() {
        return new UniversalAutomatonGraphView<State, I, State, Acceptance, Void, TransitionSystemView>(new TransitionSystemView(), (Collection)this.inputAlphabet){

            public VisualizationHelper<State, TransitionEdge<I, State>> getVisualizationHelper() {
                return new AbstractVisualizationHelper<State, I, State, TransitionSystemView>((TransitionSystemView)this.automaton){

                    @Override
                    public boolean getNodeProperties(State node, Map<String, String> properties) {
                        super.getNodeProperties(node, properties);
                        if (node.isConfluence()) {
                            String shape = node.getAcceptance() == Acceptance.TRUE ? "doubleoctagon" : "octagon";
                            properties.put("shape", shape);
                        }
                        return true;
                    }

                    @Override
                    public Acceptance getAcceptance(State state) {
                        return state.getAcceptance();
                    }
                };
            }
        };
    }

    private class TransitionSystemView
    implements UniversalDTS<State, I, State, Acceptance, Void>,
    UniversalAutomaton<State, I, State, Acceptance, Void> {
        private TransitionSystemView() {
        }

        public State getSuccessor(State transition) {
            return transition;
        }

        public State getTransition(State state, I input) {
            if (state == AbstractIncrementalDFADAGBuilder.this.sink) {
                return state;
            }
            int idx = AbstractIncrementalDFADAGBuilder.this.inputAlphabet.getSymbolIndex(input);
            return state.getSuccessor(idx);
        }

        public State getInitialState() {
            return AbstractIncrementalDFADAGBuilder.this.init;
        }

        public Acceptance getStateProperty(State state) {
            return state.getAcceptance();
        }

        public Void getTransitionProperty(State transition) {
            return null;
        }

        public Collection<State> getStates() {
            if (AbstractIncrementalDFADAGBuilder.this.sink == null) {
                return Collections.unmodifiableCollection(AbstractIncrementalDFADAGBuilder.this.register.values());
            }
            ArrayList<State> result = new ArrayList<State>(AbstractIncrementalDFADAGBuilder.this.register.size() + 1);
            result.addAll(AbstractIncrementalDFADAGBuilder.this.register.values());
            result.add(AbstractIncrementalDFADAGBuilder.this.sink);
            return result;
        }
    }

    private static final class Record<S, I> {
        public final State state1;
        public final S state2;
        public final I reachedVia;
        public final @Nullable Record<S, I> reachedFrom;
        public final int depth;

        Record(State state1, S state2) {
            this.state1 = state1;
            this.state2 = state2;
            this.reachedVia = null;
            this.reachedFrom = null;
            this.depth = 0;
        }

        Record(State state1, S state2, I reachedVia, Record<S, I> reachedFrom) {
            this.state1 = state1;
            this.state2 = state2;
            this.reachedVia = reachedVia;
            this.reachedFrom = reachedFrom;
            this.depth = reachedFrom.depth + 1;
        }
    }
}

