/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa.dag;

import java.util.ArrayDeque;
import java.util.Iterator;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.dag.AbstractIncrementalDFADAGBuilder;
import net.automatalib.incremental.dfa.dag.State;
import net.automatalib.incremental.dfa.dag.StateSignature;
import net.automatalib.incremental.dfa.dag.Transition;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IncrementalDFADAGBuilder<I>
extends AbstractIncrementalDFADAGBuilder<I> {
    public IncrementalDFADAGBuilder(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
    }

    @Override
    public Acceptance lookup(Word<? extends I> word) {
        State s = this.getState(word);
        if (s == null) {
            return Acceptance.DONT_KNOW;
        }
        return s.getAcceptance();
    }

    @Override
    public void insert(Word<? extends I> word, boolean accepting) {
        int idx;
        State state;
        Transition next;
        int len = word.length();
        Acceptance acc = Acceptance.fromBoolean(accepting);
        State curr = this.init;
        State conf = null;
        ArrayDeque<Transition> path = new ArrayDeque<Transition>();
        for (Object sym : word) {
            int idx2;
            State succ;
            if (conf == null && curr.isConfluence()) {
                conf = curr;
            }
            if ((succ = curr.getSuccessor(idx2 = this.inputAlphabet.getSymbolIndex(sym))) == null) break;
            path.push(new Transition(curr, idx2));
            curr = succ;
        }
        int prefixLen = path.size();
        State last = curr;
        if (prefixLen == len) {
            Acceptance currAcc = curr.getAcceptance();
            if (currAcc == acc) {
                return;
            }
            if (currAcc != Acceptance.DONT_KNOW) {
                throw new ConflictException("Incompatible acceptances: " + (Object)((Object)currAcc) + " vs " + (Object)((Object)acc));
            }
            if (conf != null || last.isConfluence()) {
                last = this.clone(last, acc);
            } else {
                if (last == this.init) {
                    this.updateInitSignature(acc);
                    return;
                }
                last = this.updateSignature(last, acc);
            }
        } else {
            if (conf != null) {
                if (conf == last) {
                    conf = null;
                }
                last = this.hiddenClone(last);
                if (conf == null) {
                    Transition peek = (Transition)path.peek();
                    assert (peek != null);
                    State prev = peek.state;
                    if (prev != this.init) {
                        this.updateSignature(prev, peek.transIdx, last);
                    } else {
                        this.updateInitSignature(peek.transIdx, last);
                    }
                }
            } else if (last != this.init) {
                this.hide(last);
            }
            Word suffix = word.subWord(prefixLen);
            Object sym = suffix.firstSymbol();
            int suffTransIdx = this.inputAlphabet.getSymbolIndex(sym);
            State suffixState = this.createSuffix(suffix.subWord(1), acc);
            if (last != this.init) {
                last = this.unhide(last, suffTransIdx, suffixState);
                if (suffixState.isConfluence()) {
                    Iterator iter = path.descendingIterator();
                    while (iter.hasNext()) {
                        State s = ((Transition)iter.next()).state;
                        if (s != conf && s != suffixState) continue;
                        conf = s;
                        break;
                    }
                }
            } else {
                this.updateInitSignature(suffTransIdx, suffixState);
            }
        }
        if (path.isEmpty()) {
            return;
        }
        if (conf != null) {
            do {
                next = (Transition)path.pop();
                state = next.state;
                idx = next.transIdx;
                last = state = this.clone(state, idx, last);
            } while (next.state != conf);
        }
        while (path.size() > 1) {
            next = (Transition)path.pop();
            state = next.state;
            idx = next.transIdx;
            if (state == last) {
                last = this.clone(state, idx, last);
                continue;
            }
            State updated = this.updateSignature(state, idx, last);
            if (state == updated) {
                return;
            }
            last = updated;
        }
        int finalIdx = ((Transition)path.pop()).transIdx;
        this.updateInitSignature(finalIdx, last);
    }

    private State createSuffix(Word<? extends I> suffix, Acceptance acc) {
        StateSignature sig = new StateSignature(this.alphabetSize, acc);
        sig.updateHashCode();
        State last = this.replaceOrRegister(sig);
        int len = suffix.length();
        for (int i = len - 1; i >= 0; --i) {
            sig = new StateSignature(this.alphabetSize, Acceptance.DONT_KNOW);
            Object sym = suffix.getSymbol(i);
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            ((State[])sig.successors.array)[idx] = last;
            sig.updateHashCode();
            last = this.replaceOrRegister(sig);
        }
        return last;
    }

    @Override
    @Nullable State getState(Word<? extends I> word) {
        State s = this.init;
        for (Object sym : word) {
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            if ((s = s.getSuccessor(idx)) != null) continue;
            return null;
        }
        return s;
    }
}

