/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy;

import java.util.ArrayList;
import java.util.List;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.incremental.IncrementalConstruction;
import net.automatalib.ts.output.MealyTransitionSystem;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public interface MealyBuilder<I, O>
extends IncrementalConstruction<MealyMachine<?, I, ?, O>, I>,
SupportsGrowingAlphabet<I> {
    public boolean lookup(Word<? extends I> var1, List<? super O> var2);

    default public Word<O> lookup(Word<? extends I> inputWord) {
        WordBuilder wb = new WordBuilder(inputWord.size());
        this.lookup(inputWord, (List<? super O>)wb);
        return wb.toWord();
    }

    @Override
    default public boolean hasDefinitiveInformation(Word<? extends I> word) {
        return this.lookup(word, new ArrayList(word.length()));
    }

    public MealyTransitionSystem<?, I, ?, O> asTransitionSystem();
}

