/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.tree;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.automaton.concept.InputAlphabetHolder;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.mapping.MapMapping;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.graph.Graph;
import net.automatalib.incremental.mealy.VisualizationHelper;
import net.automatalib.incremental.mealy.tree.AbstractMealyTreeBuilder;
import net.automatalib.incremental.mealy.tree.Edge;
import net.automatalib.incremental.mealy.tree.Node;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.util.ts.traversal.TSTraversal;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractAlphabetBasedMealyTreeBuilder<I, O>
extends AbstractMealyTreeBuilder<Node<O>, I, O>
implements InputAlphabetHolder<I> {
    private final Alphabet<I> inputAlphabet;
    private int alphabetSize;

    AbstractAlphabetBasedMealyTreeBuilder(Alphabet<I> inputAlphabet) {
        super(new Node(inputAlphabet.size()));
        this.inputAlphabet = inputAlphabet;
        this.alphabetSize = inputAlphabet.size();
    }

    public void addAlphabetSymbol(I symbol) {
        int newAlphabetSize;
        if (!this.inputAlphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.inputAlphabet).addSymbol(symbol);
        }
        if (this.alphabetSize < (newAlphabetSize = this.inputAlphabet.size())) {
            this.ensureInputCapacity((Node)this.root, this.alphabetSize, newAlphabetSize);
            this.alphabetSize = newAlphabetSize;
        }
    }

    private void ensureInputCapacity(Node<O> node, int oldAlphabetSize, int newAlphabetSize) {
        node.ensureInputCapacity(newAlphabetSize);
        for (int i = 0; i < oldAlphabetSize; ++i) {
            Node<O> child = node.getSuccessor(i);
            if (child == null) continue;
            this.ensureInputCapacity(child, oldAlphabetSize, newAlphabetSize);
        }
    }

    @Override
    @Nullable Edge<Node<O>, O> getEdge(Node<O> node, I symbol) {
        return node.getEdge(this.inputAlphabet.getSymbolIndex(symbol));
    }

    @Override
    Node<O> createNode() {
        return new Node(this.alphabetSize);
    }

    @Override
    Node<O> insertNode(Node<O> parent, I symIdx, O output) {
        Object succ = this.createNode();
        Edge<Object, O> edge = new Edge<Object, O>(output, succ);
        parent.setEdge(this.inputAlphabet.getSymbolIndex(symIdx), edge);
        return succ;
    }

    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    @Override
    public Graph<Node<O>, ?> asGraph() {
        return new MealyMachine.MealyGraphView<Node<O>, I, Edge<Node<O>, O>, O, MealyMachineView>(new MealyMachineView(), (Collection)this.inputAlphabet){

            public net.automatalib.visualization.VisualizationHelper<Node<O>, TransitionEdge<I, Edge<Node<O>, O>>> getVisualizationHelper() {
                return new VisualizationHelper((MealyMachine)this.automaton);
            }
        };
    }

    private class MealyMachineView
    extends AbstractMealyTreeBuilder.TransitionSystemView
    implements MealyMachine<Node<O>, I, Edge<Node<O>, O>, O> {
        private MealyMachineView() {
            super(AbstractAlphabetBasedMealyTreeBuilder.this);
        }

        public Collection<Node<O>> getStates() {
            ArrayList result = new ArrayList();
            Iterators.addAll(result, (Iterator)TSTraversal.breadthFirstIterator((TransitionSystem)this, (Collection)AbstractAlphabetBasedMealyTreeBuilder.this.inputAlphabet));
            return result;
        }

        public <V> MutableMapping<Node<O>, V> createStaticStateMapping() {
            return new MapMapping();
        }
    }
}

