/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.tree;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.incremental.mealy.MealyBuilder;
import net.automatalib.incremental.mealy.tree.Edge;
import net.automatalib.ts.output.MealyTransitionSystem;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractMealyTreeBuilder<N, I, O>
implements MealyBuilder<I, O> {
    final N root;

    AbstractMealyTreeBuilder(N root) {
        this.root = root;
    }

    @Override
    public boolean lookup(Word<? extends I> word, List<? super O> output) {
        N curr = this.root;
        for (Object sym : word) {
            Edge<N, O> edge = this.getEdge(curr, sym);
            if (edge == null) {
                return false;
            }
            output.add(edge.getOutput());
            curr = edge.getTarget();
        }
        return true;
    }

    @Override
    public @Nullable Word<I> findSeparatingWord(MealyMachine<?, I, ?, O> target, Collection<? extends I> inputs, boolean omitUndefined) {
        return this.doFindSeparatingWord(target, inputs, omitUndefined);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private <S, T> @Nullable Word<I> doFindSeparatingWord(MealyMachine<S, I, T, O> target, Collection<? extends I> inputs, boolean omitUndefined) {
        Object automatonInit = target.getInitialState();
        if (automatonInit == null) {
            return omitUndefined ? null : Word.epsilon();
        }
        ArrayDeque<Record<@Nullable Object, Object, ? extends I>> dfsStack = new ArrayDeque<Record<Object, Object, ? extends I>>();
        Record<@Nullable Object, N, ? extends I> init = new Record<Object, N, I>(automatonInit, this.root, null, inputs.iterator());
        dfsStack.push(init);
        while (!dfsStack.isEmpty()) {
            Object trans;
            @Nullable @NonNull Record rec = (Record)dfsStack.peek();
            if (!rec.inputIt.hasNext()) {
                dfsStack.pop();
                continue;
            }
            Object input = rec.inputIt.next();
            Edge<Object, O> edge = this.getEdge(rec.treeNode, input);
            if (edge == null) continue;
            Object state = rec.automatonState;
            Object object = trans = state == null ? null : target.getTransition(state, input);
            if (omitUndefined && trans == null) continue;
            if (trans == null || !Objects.equals(target.getTransitionOutput(trans), edge.getOutput())) {
                WordBuilder wb = new WordBuilder(dfsStack.size());
                wb.append(input);
                dfsStack.pop();
                while (!dfsStack.isEmpty()) {
                    wb.append(rec.incomingInput);
                    rec = (Record)dfsStack.pop();
                }
                return wb.reverse().toWord();
            }
            Record<@Nullable Object, Object, ? extends I> nextRecord = new Record<Object, Object, I>(target.getSuccessor(trans), edge.getTarget(), input, inputs.iterator());
            dfsStack.push(nextRecord);
        }
        return null;
    }

    @Override
    public MealyTransitionSystem<?, I, ?, O> asTransitionSystem() {
        return new TransitionSystemView();
    }

    abstract @Nullable Edge<N, O> getEdge(N var1, I var2);

    abstract N createNode();

    abstract N insertNode(N var1, I var2, O var3);

    class TransitionSystemView
    implements MealyTransitionSystem<N, I, Edge<N, O>, O> {
        TransitionSystemView() {
        }

        public @Nullable Edge<N, O> getTransition(N state, I input) {
            return AbstractMealyTreeBuilder.this.getEdge(state, input);
        }

        public N getSuccessor(Edge<N, O> transition) {
            return transition.getTarget();
        }

        public N getInitialState() {
            return AbstractMealyTreeBuilder.this.root;
        }

        public O getTransitionOutput(Edge<N, O> transition) {
            return transition.getOutput();
        }
    }

    private static final class Record<S, N, I> {
        private final S automatonState;
        private final N treeNode;
        private final I incomingInput;
        private final Iterator<? extends I> inputIt;

        Record(S automatonState, N treeNode, I incomingInput, Iterator<? extends I> inputIt) {
            this.automatonState = automatonState;
            this.treeNode = treeNode;
            this.inputIt = inputIt;
            this.incomingInput = incomingInput;
        }
    }
}

