/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.tree;

import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.incremental.mealy.tree.AbstractAlphabetBasedMealyTreeBuilder;
import net.automatalib.incremental.mealy.tree.Edge;
import net.automatalib.incremental.mealy.tree.Node;
import net.automatalib.word.Word;

public class IncrementalMealyTreeBuilder<I, O>
extends AbstractAlphabetBasedMealyTreeBuilder<I, O>
implements IncrementalMealyBuilder<I, O> {
    public IncrementalMealyTreeBuilder(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
    }

    @Override
    public void insert(Word<? extends I> input, Word<? extends O> outputWord) {
        Node<Object> curr = (Node<Object>)this.root;
        for (int i = 0; i < input.length(); ++i) {
            Object sym = input.getSymbol(i);
            Object out = outputWord.getSymbol(i);
            Edge edge = this.getEdge(curr, sym);
            if (edge == null) {
                curr = this.insertNode(curr, sym, out);
                continue;
            }
            if (!Objects.equals(out, edge.getOutput())) {
                throw new ConflictException();
            }
            curr = edge.getTarget();
        }
    }
}

