/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.moore.dag;

import java.util.Arrays;
import java.util.Objects;
import net.automatalib.common.smartcollection.ResizingArrayStorage;
import net.automatalib.incremental.moore.dag.State;
import org.checkerframework.checker.nullness.qual.Nullable;

final class StateSignature<O> {
    final ResizingArrayStorage<State<O>> successors;
    final O output;
    private int hashCode;

    StateSignature(int numSuccs, O output) {
        this.successors = new ResizingArrayStorage(State.class, numSuccs);
        this.output = output;
        this.updateHashCode();
    }

    StateSignature(StateSignature<O> other) {
        this.successors = new ResizingArrayStorage(other.successors);
        this.output = other.output;
        this.updateHashCode();
    }

    StateSignature<O> duplicate() {
        return new StateSignature<O>(this);
    }

    void updateHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.successors.array);
        this.hashCode = result = 31 * result + Objects.hashCode(this.output);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StateSignature)) {
            return false;
        }
        StateSignature other = (StateSignature)obj;
        return this.hashCode == other.hashCode && Objects.equals(this.output, other.output) && Arrays.equals(this.successors.array, other.successors.array);
    }
}

