/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.moore.tree;

import net.automatalib.common.smartcollection.ResizingArrayStorage;
import org.checkerframework.checker.nullness.qual.Nullable;

final class Node<O> {
    private final O output;
    private @Nullable ResizingArrayStorage<Node<O>> children;

    Node(O output) {
        this.output = output;
    }

    O getOutput() {
        return this.output;
    }

    @Nullable Node<O> getChild(int idx) {
        if (this.children == null) {
            return null;
        }
        return ((Node[])this.children.array)[idx];
    }

    void setChild(int idx, int alphabetSize, Node<O> child) {
        if (this.children == null) {
            this.children = new ResizingArrayStorage(Node.class, alphabetSize);
        }
        ((Node[])this.children.array)[idx] = child;
    }

    void ensureInputCapacity(int capacity) {
        if (this.children != null) {
            this.children.ensureCapacity(capacity);
        }
    }
}

