/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.graphs.dot.DefaultDOTHelper;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.EdgeRecord;
import net.automatalib.incremental.dfa.State;
import net.automatalib.words.Alphabet;

final class DOTHelper
extends DefaultDOTHelper<State, EdgeRecord> {
    private final Alphabet<?> alphabet;
    private final State initial;

    public DOTHelper(Alphabet<?> alphabet, State initial) {
        this.alphabet = alphabet;
        this.initial = initial;
    }

    protected Collection<? extends State> initialNodes() {
        return Collections.singleton(this.initial);
    }

    public boolean getNodeProperties(State node, Map<String, String> properties) {
        String baseShape;
        if (!super.getNodeProperties((Object)node, properties)) {
            return false;
        }
        String string = baseShape = node.isConfluence() ? "octagon" : "circle";
        if (node.getAcceptance() == Acceptance.TRUE) {
            properties.put("shape", "double" + baseShape);
        } else {
            properties.put("shape", baseShape);
            if (node.getAcceptance() == Acceptance.DONT_KNOW) {
                properties.put("style", "dashed");
            }
        }
        return true;
    }

    public boolean getEdgeProperties(State src, EdgeRecord edge, State tgt, Map<String, String> properties) {
        if (!super.getEdgeProperties((Object)src, (Object)edge, (Object)tgt, properties)) {
            return false;
        }
        Object sym = this.alphabet.getSymbol(edge.transIdx);
        properties.put("label", String.valueOf(sym));
        return true;
    }
}

