/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa;

import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.dfa.AbstractIncrementalDFABuilder;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.State;
import net.automatalib.incremental.dfa.StateSignature;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class IncrementalDFABuilder<I>
extends AbstractIncrementalDFABuilder<I> {
    public IncrementalDFABuilder(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
    }

    @Override
    public Acceptance lookup(Word<I> word) {
        State s = this.getState(word);
        if (s == null) {
            return Acceptance.DONT_KNOW;
        }
        return s.getAcceptance();
    }

    @Override
    public void insert(Word<I> word, boolean accepting) {
        int currentIndex;
        State last;
        int len = word.length();
        Acceptance acc = Acceptance.fromBoolean(accepting);
        State curr = this.init;
        State conf = null;
        int confIndex = -1;
        int prefixLen = 0;
        for (Object sym : word) {
            int idx;
            State succ;
            if (conf == null && curr.isConfluence()) {
                conf = curr;
                confIndex = prefixLen;
            }
            if ((succ = curr.getSuccessor(idx = this.inputAlphabet.getSymbolIndex(sym))) == null) break;
            curr = succ;
            ++prefixLen;
        }
        if (prefixLen == len) {
            Acceptance currAcc = curr.getAcceptance();
            if (currAcc == acc) {
                return;
            }
            if (conf == null) {
                if (currAcc == Acceptance.DONT_KNOW) {
                    if (curr == this.init) {
                        this.updateInitSignature(acc);
                        return;
                    }
                    State upd = this.updateSignature(curr, acc);
                    if (upd == curr) {
                        return;
                    }
                    curr = upd;
                } else {
                    throw new ConflictException("Incompatible acceptances: " + (Object)((Object)currAcc) + " vs. " + (Object)((Object)acc));
                }
            }
        }
        Word suffix = word.subWord(prefixLen);
        State suffixState = null;
        State endpoint = null;
        int suffTransIdx = -1;
        if (!suffix.isEmpty()) {
            if (conf != null) {
                suffixState = this.createSuffix(suffix.subWord(1), acc);
            } else {
                SuffixInfo suffixRes = this.createSuffix2(suffix.subWord(1), acc);
                suffixState = suffixRes.last;
                endpoint = suffixRes.end;
            }
            Object sym = suffix.getSymbol(0);
            suffTransIdx = this.inputAlphabet.getSymbolIndex(sym);
        }
        if (conf != null) {
            last = suffTransIdx == -1 ? this.clone(curr, acc) : this.clone(curr, suffTransIdx, suffixState);
            for (int i = prefixLen - 1; i >= confIndex; --i) {
                State s = this.getState(word.prefix(i));
                Object sym = word.getSymbol(i);
                int idx = this.inputAlphabet.getSymbolIndex(sym);
                last = this.clone(s, idx, last);
            }
            currentIndex = confIndex;
        } else {
            if (suffTransIdx == -1) {
                last = curr;
            } else if (endpoint == curr) {
                last = this.clone(curr, suffTransIdx, suffixState);
            } else {
                if (curr == this.init) {
                    this.updateInitSignature(suffTransIdx, suffixState);
                    return;
                }
                last = this.updateSignature(curr, suffTransIdx, suffixState);
            }
            currentIndex = prefixLen;
        }
        while (--currentIndex > 0) {
            Object sym;
            int idx;
            State state = this.getState(word.prefix(currentIndex));
            if (state != (last = this.updateSignature(state, idx = this.inputAlphabet.getSymbolIndex(sym = word.getSymbol(currentIndex)), last))) continue;
            return;
        }
        Object sym = word.getSymbol(0);
        int idx = this.inputAlphabet.getSymbolIndex(sym);
        this.updateInitSignature(idx, last);
    }

    @Override
    protected State getState(Word<I> word) {
        State s = this.init;
        for (Object sym : word) {
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            if ((s = s.getSuccessor(idx)) != null) continue;
            return null;
        }
        return s;
    }

    private State createSuffix(Word<I> suffix, Acceptance acc) {
        StateSignature sig = new StateSignature(this.alphabetSize, acc);
        sig.updateHashCode();
        State last = this.replaceOrRegister(sig);
        int len = suffix.length();
        for (int i = len - 1; i >= 0; --i) {
            sig = new StateSignature(this.alphabetSize, Acceptance.DONT_KNOW);
            Object sym = suffix.getSymbol(i);
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            sig.successors[idx] = last;
            sig.updateHashCode();
            last = this.replaceOrRegister(sig);
        }
        return last;
    }

    private SuffixInfo createSuffix2(Word<I> suffix, Acceptance acc) {
        State last;
        StateSignature sig = new StateSignature(this.alphabetSize, acc);
        sig.updateHashCode();
        State end = last = this.replaceOrRegister(sig);
        int len = suffix.length();
        for (int i = len - 1; i >= 0; --i) {
            sig = new StateSignature(this.alphabetSize, Acceptance.DONT_KNOW);
            Object sym = suffix.getSymbol(i);
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            sig.successors[idx] = last;
            sig.updateHashCode();
            last = this.replaceOrRegister(sig);
        }
        return new SuffixInfo(last, end);
    }

    private static final class SuffixInfo {
        private final State last;
        private final State end;

        public SuffixInfo(State last, State end) {
            this.last = last;
            this.end = end;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
            result = 31 * result + (this.last == null ? 0 : this.last.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != SuffixInfo.class) {
                return false;
            }
            SuffixInfo other = (SuffixInfo)obj;
            if (this.last != other.last) {
                return false;
            }
            return this.end == other.end;
        }
    }
}

