/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa;

import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.dfa.AbstractIncrementalDFABuilder;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.State;
import net.automatalib.incremental.dfa.StateSignature;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class IncrementalPCDFABuilder<I>
extends AbstractIncrementalDFABuilder<I> {
    public IncrementalPCDFABuilder(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
    }

    @Override
    protected State getState(Word<I> word) {
        State s = this.init;
        for (Object sym : word) {
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            if ((s = s.getSuccessor(idx)) != null && s != this.sink) continue;
            return s;
        }
        return s;
    }

    @Override
    public Acceptance lookup(Word<I> word) {
        State s = this.getState(word);
        if (s == null) {
            return Acceptance.DONT_KNOW;
        }
        return s != this.sink ? s.getAcceptance() : Acceptance.FALSE;
    }

    @Override
    public void insert(Word<I> word, boolean accepting) {
        int currentIndex;
        State last;
        int len = word.length();
        Acceptance acc = Acceptance.fromBoolean(accepting);
        State curr = this.init;
        State conf = null;
        int confIndex = -1;
        int prefixLen = 0;
        for (Object sym : word) {
            int idx;
            State succ;
            if (curr == this.sink) break;
            if (conf == null && curr.isConfluence()) {
                conf = curr;
                confIndex = prefixLen;
            }
            if ((succ = curr.getSuccessor(idx = this.inputAlphabet.getSymbolIndex(sym))) == null) break;
            curr = succ;
            ++prefixLen;
        }
        if (curr == this.sink) {
            if (accepting) {
                throw new RuntimeException("Conflict");
            }
            return;
        }
        if (prefixLen == len) {
            Acceptance currAcc = curr.getAcceptance();
            if (currAcc == acc) {
                return;
            }
            if (conf == null) {
                if (currAcc == Acceptance.DONT_KNOW) {
                    if (accepting) {
                        State upd = this.updateSignature(curr, Acceptance.TRUE);
                        if (upd == curr) {
                            return;
                        }
                        curr = upd;
                    } else {
                        this.purge(curr);
                        curr = this.sink;
                    }
                } else {
                    throw new ConflictException("Incompatible acceptances: " + (Object)((Object)currAcc) + " vs " + (Object)((Object)acc));
                }
            }
        }
        Word suffix = word.subWord(prefixLen);
        State suffixState = null;
        int suffTransIdx = -1;
        if (!suffix.isEmpty()) {
            suffixState = this.createSuffix(suffix.subWord(1), accepting);
            Object sym = suffix.getSymbol(0);
            suffTransIdx = this.inputAlphabet.getSymbolIndex(sym);
        }
        if (conf != null) {
            last = suffTransIdx == -1 ? this.clone(curr, acc) : this.clone(curr, Acceptance.TRUE, suffTransIdx, suffixState);
            for (int i = prefixLen - 1; i >= confIndex; --i) {
                State s = this.getState(word.prefix(i));
                Object sym = word.getSymbol(i);
                int idx = this.inputAlphabet.getSymbolIndex(sym);
                last = accepting ? this.clone(s, Acceptance.TRUE, idx, last) : this.clone(s, idx, last);
            }
            currentIndex = confIndex;
        } else {
            last = suffTransIdx == -1 ? this.updateSignature(curr, acc) : this.updateSignature(curr, Acceptance.TRUE, suffTransIdx, suffixState);
            currentIndex = prefixLen;
        }
        while (--currentIndex >= 0) {
            State state = this.getState(word.prefix(currentIndex));
            Object sym = word.getSymbol(currentIndex);
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            if (accepting) {
                Acceptance lastAcc = last.getAcceptance();
                if (state != (last = this.updateSignature(state, Acceptance.TRUE, idx, last)) || lastAcc != Acceptance.TRUE) continue;
                break;
            }
            if (state != (last = this.updateSignature(state, idx, last))) continue;
            break;
        }
    }

    private void purge(State state) {
        StateSignature sig = state.getSignature();
        if (this.register.remove(sig) == null) {
            return;
        }
        for (int i = 0; i < this.alphabetSize; ++i) {
            State succ = sig.successors[i];
            if (succ != null) {
                this.purge(succ);
            }
            sig.successors[i] = null;
        }
    }

    private State createSuffix(Word<I> suffix, boolean accepting) {
        Acceptance intermediate;
        State last;
        if (!accepting) {
            if (this.sink == null) {
                this.sink = new State(null);
            }
            last = this.sink;
            intermediate = Acceptance.DONT_KNOW;
        } else {
            StateSignature sig = new StateSignature(this.alphabetSize, Acceptance.TRUE);
            last = this.replaceOrRegister(sig);
            intermediate = Acceptance.TRUE;
        }
        int len = suffix.length();
        for (int i = len - 1; i >= 0; --i) {
            StateSignature sig = new StateSignature(this.alphabetSize, intermediate);
            Object sym = suffix.getSymbol(i);
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            sig.successors[idx] = last;
            last = this.replaceOrRegister(sig);
        }
        return last;
    }
}

