/* InternalTAFParser.java */
/* Generated By:JavaCC: Do not edit this line. InternalTAFParser.java */
package net.automatalib.serialization.taf.parser;

import java.util.Collections;
import java.util.Collection;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import java.util.HashSet;

import java.text.MessageFormat;

import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.alphabet.GrowingMapAlphabet;
import net.automatalib.common.util.string.StringUtil;

class InternalTAFParser implements InternalTAFParserConstants {

        private TAFParseDiagnosticListener listener;

        public void error(String fmtString, Object... args) {
                if (listener != null) {
                        listener.error(getLine(), getCol(), fmtString, args);
                }
        }

        public void warning(String fmtString, Object... args) {
                if (listener != null) {
                        listener.error(getLine(), getCol(), fmtString, args);
                }
        }

        public void fatal(String fmtString, Object... args) {
                throw new TAFFormatException("At line " + getLine() + ", column " + getCol() + ": "
                        + MessageFormat.format(fmtString, args));
        }

        public void setDiagnosticListener(TAFParseDiagnosticListener listener) {
                this.listener = listener;
        }

        private int getLine() {
                return token.beginLine;
        }

        private int getCol() {
                return token.beginColumn;
        }

  final public Alphabet<String> charStringRange() throws ParseException {char l, r;
    jj_consume_token(LBRACK);
    l = singleChar();
    jj_consume_token(DOTS);
    r = singleChar();
    jj_consume_token(RBRACK);
if (l > r) {
                        error("Invalid character range [{0}..{1}]", l, r);
                        {if ("" != null) return null;}
                }
                {if ("" != null) return Alphabets.closedCharStringRange(l, r);}
    throw new Error("Missing return statement in function");
}

  final public Alphabet<String> stringSet() throws ParseException {Alphabet<String> result = new GrowingMapAlphabet<String>();
        String s;
    jj_consume_token(LBRACE);
    s = string();
result.add(s);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      jj_consume_token(COMMA);
      s = string();
result.add(s);
    }
    jj_consume_token(RBRACE);
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public char singleChar() throws ParseException {Token t;
    t = jj_consume_token(LC_ALPHA);
{if ("" != null) return t.toString().charAt(0);}
    throw new Error("Missing return statement in function");
}

  final public Alphabet<String> stringCollection() throws ParseException {Alphabet<String> sc;
        String s;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACK:{
      sc = charStringRange();
      break;
      }
    case LBRACE:{
      sc = stringSet();
      break;
      }
    case LC_ALPHA:
    case ID:
    case NUMBER:
    case QID:{
      s = string();
sc = Alphabets.singleton(s);
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return sc;}
    throw new Error("Missing return statement in function");
}

  final public String identifier() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ID:{
      t = jj_consume_token(ID);
{if ("" != null) return t.toString();}
      break;
      }
    case LC_ALPHA:{
      t = jj_consume_token(LC_ALPHA);
{if ("" != null) return t.toString();}
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public String string() throws ParseException {String s;
        Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LC_ALPHA:
    case ID:{
      s = identifier();
      break;
      }
    case QID:{
      t = jj_consume_token(QID);
s = StringUtil.unescapeQuotes(t.toString());
      break;
      }
    case NUMBER:{
      t = jj_consume_token(NUMBER);
s = t.toString();
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return s;}
    throw new Error("Missing return statement in function");
}

  final public Set<String> stateOpts() throws ParseException {Set<String> result = Collections.emptySet();
        String s;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACK:{
      jj_consume_token(LBRACK);
      s = identifier();
result = new HashSet<String>(); result.add(s);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[4] = jj_gen;
          break label_2;
        }
        jj_consume_token(COMMA);
        s = identifier();
result.add(s);
      }
      jj_consume_token(RBRACK);
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      ;
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final public Type type() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DFA:{
      jj_consume_token(DFA);
{if ("" != null) return Type.DFA;}
      break;
      }
    case MEALY:{
      jj_consume_token(MEALY);
{if ("" != null) return Type.MEALY;}
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public void dfa(TAFBuilderDFA builder) throws ParseException {
    jj_consume_token(DFA);
    dfaBody(builder);
}

  final public void dfaBody(TAFBuilderDFA builder) throws ParseException {Alphabet<String> alphabet;
    alphabet = stringCollection();
if (alphabet == null) {
                        fatal("No valid alphabet specified");
                }
                builder.init(alphabet);
    jj_consume_token(LBRACE);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LC_ALPHA:
      case ID:{
        ;
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        break label_3;
      }
      stateDeclDfa(builder);
    }
    jj_consume_token(RBRACE);
}

  final public void stateDeclDfa(TAFBuilderDFA builder) throws ParseException {String id;
        Set<String> opts;
    id = identifier();
    opts = stateOpts();
builder.declareState(id, opts);
    transBlockDfa(builder, id);
}

  final public void transBlockDfa(TAFBuilderDFA builder, String source) throws ParseException {
    jj_consume_token(LBRACE);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACK:
      case LBRACE:
      case LC_ALPHA:
      case ID:
      case NUMBER:
      case QID:{
        ;
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_4;
      }
      transDeclDfa(builder, source);
    }
    jj_consume_token(RBRACE);
}

  final public void transDeclDfa(TAFBuilderDFA builder, String source) throws ParseException {Collection<String> symbols;
        String tgt;
    symbols = stringCollection();
    jj_consume_token(ARROW);
    tgt = identifier();
if (symbols != null) { builder.addTransitions(source, symbols, tgt); }
}

  final public void wildcardTransDeclDfa(TAFBuilderDFA builder, String source) throws ParseException {String tgt;
    jj_consume_token(ASTERISK);
    jj_consume_token(ARROW);
    tgt = identifier();
builder.addWildcardTransitions(source, tgt);
}

  final public void mealy(TAFBuilderMealy builder) throws ParseException {
    jj_consume_token(MEALY);
    mealyBody(builder);
}

  final public void mealyBody(TAFBuilderMealy builder) throws ParseException {Alphabet<String> alphabet;
    alphabet = stringCollection();
if (alphabet == null) {
                        fatal("No valid alphabet specified");
                }
                builder.init(alphabet);
    jj_consume_token(LBRACE);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LC_ALPHA:
      case ID:{
        ;
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        break label_5;
      }
      stateDeclMealy(builder);
    }
    jj_consume_token(RBRACE);
}

  final public void stateDeclMealy(TAFBuilderMealy builder) throws ParseException {String id;
        Set<String> opts;
    id = identifier();
    opts = stateOpts();
builder.declareState(id, opts);
    transBlockMealy(builder, id);
}

  final public void transBlockMealy(TAFBuilderMealy builder, String source) throws ParseException {
    jj_consume_token(LBRACE);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACK:
      case LBRACE:
      case LC_ALPHA:
      case ID:
      case NUMBER:
      case QID:{
        ;
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_6;
      }
      transDeclMealy(builder, source);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASTERISK:{
      wildcardTransDeclMealy(builder, source);
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
}

  final public void transDeclMealy(TAFBuilderMealy builder, String source) throws ParseException {Collection<String> symbols;
        String output = null;
        String tgt;
    symbols = stringCollection();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SLASH:{
      jj_consume_token(SLASH);
      output = string();
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    jj_consume_token(ARROW);
    tgt = identifier();
if (symbols != null) { builder.addTransitions(source, symbols, output, tgt); }
}

  final public void wildcardTransDeclMealy(TAFBuilderMealy builder, String source) throws ParseException {String output = null;
        String tgt;
    jj_consume_token(ASTERISK);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SLASH:{
      jj_consume_token(SLASH);
      output = string();
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    jj_consume_token(ARROW);
    tgt = identifier();
builder.addWildcardTransitions(source, output, tgt);
}

  /** Generated Token Manager. */
  public InternalTAFParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[14];
  static private int[] jj_la1_0;
  static {
	   jj_la1_init_0();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x1000,0x170480,0x30000,0x170000,0x1000,0x80,0x60,0x30000,0x170480,0x30000,0x170480,0x4000,0x2000,0x2000,};
	}

  /** Constructor with InputStream. */
  public InternalTAFParser(java.io.InputStream stream) {
	  this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public InternalTAFParser(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source = new InternalTAFParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 14; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 14; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public InternalTAFParser(java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new InternalTAFParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 14; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new InternalTAFParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 14; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public InternalTAFParser(InternalTAFParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 14; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(InternalTAFParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 14; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[28];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 14; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 28; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
