/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.copy;

import java.util.ArrayList;
import java.util.Collection;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.ts.TransitionSystem;

abstract class AbstractAutomatonCopy<S1, I1, T1, S2, I2, T2, SP2, TP2, TS1 extends TransitionSystem<S1, I1, T1>> {
    protected final TS1 in;
    protected final Collection<? extends I1> inputs;
    protected final MutableAutomaton<S2, I2, T2, SP2, TP2> out;
    protected final MutableMapping<S1, S2> stateMapping;
    protected final Mapping<? super I1, ? extends I2> inputsMapping;
    protected final Mapping<? super S1, ? extends SP2> spMapping;
    protected final Mapping<? super T1, ? extends TP2> tpMapping;

    public AbstractAutomatonCopy(TS1 in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, T2, SP2, TP2> out, Mapping<? super I1, ? extends I2> inputsMapping, Mapping<? super S1, ? extends SP2> spMapping, Mapping<? super T1, ? extends TP2> tpMapping) {
        this.in = in;
        this.inputs = inputs;
        this.out = out;
        this.stateMapping = in.createStaticStateMapping();
        this.inputsMapping = inputsMapping;
        this.spMapping = spMapping;
        this.tpMapping = tpMapping;
    }

    protected S2 copyState(S1 s1) {
        Object prop = this.spMapping.get(s1);
        Object s2 = this.out.addState(prop);
        this.stateMapping.put(s1, s2);
        return (S2)s2;
    }

    protected S2 copyInitialState(S1 s1) {
        Object prop = this.spMapping.get(s1);
        Object s2 = this.out.addInitialState(prop);
        this.stateMapping.put(s1, s2);
        return (S2)s2;
    }

    protected T2 copyTransition(S2 src2, I2 input2, T1 trans1, S1 succ1) {
        Object prop = this.tpMapping.get(trans1);
        Object succ2 = this.stateMapping.get(succ1);
        Object trans2 = this.out.createTransition(succ2, prop);
        this.out.addTransition(src2, input2, trans2);
        return (T2)trans2;
    }

    protected void copyTransitions(S2 src2, I2 input2, Collection<? extends T1> transitions1) {
        ArrayList<Object> transitions2 = new ArrayList<Object>(transitions1.size());
        for (T1 trans1 : transitions1) {
            Object succ1 = this.in.getSuccessor(trans1);
            Object succ2 = this.stateMapping.get(succ1);
            Object prop = this.tpMapping.get(trans1);
            Object trans2 = this.out.createTransition(succ2, prop);
            transitions2.add(trans2);
        }
        this.out.addTransitions(src2, input2, transitions2);
    }

    protected S2 copyTransitionChecked(S2 src2, I2 input2, T1 trans1, S1 succ1) {
        Object prop = this.tpMapping.get(trans1);
        Object succ2 = this.stateMapping.get(succ1);
        S2 freshSucc = null;
        if (succ2 == null) {
            succ2 = this.copyState(succ1);
            freshSucc = (S2)succ2;
        }
        Object trans2 = this.out.createTransition(succ2, prop);
        this.out.addTransition(src2, input2, trans2);
        return freshSucc;
    }

    public abstract void doCopy();

    protected final void updateInitials() {
        for (Object init1 : this.in.getInitialStates()) {
            Object init2 = this.stateMapping.get(init1);
            if (init2 == null) continue;
            this.out.setInitial(init2, true);
        }
    }
}

