/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.copy;

import java.util.Collection;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.automata.UniversalAutomaton;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.commons.util.mappings.Mappings;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.ts.UniversalTransitionSystem;
import net.automatalib.util.automata.copy.PlainAutomatonCopy;
import net.automatalib.util.automata.copy.TraversalAutomatonCopy;
import net.automatalib.util.traversal.TraversalOrder;
import net.automatalib.util.ts.TS;

public abstract class AutomatonCopy {
    public static <S1, I1, T1, S2, I2, T2, SP2, TP2> Mapping<S1, S2> copyPlain(Automaton<S1, I1, T1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, T2, SP2, TP2> out, Mapping<? super I1, ? extends I2> inputsMapping, Mapping<? super S1, ? extends SP2> spMapping, Mapping<? super T1, ? extends TP2> tpMapping) {
        PlainAutomatonCopy<S1, I1, T1, S2, I2, T2, SP2, TP2> copy = new PlainAutomatonCopy<S1, I1, T1, S2, I2, T2, SP2, TP2>(in, inputs, out, inputsMapping, spMapping, tpMapping);
        copy.doCopy();
        return copy.stateMapping;
    }

    public static <S1, I1 extends I2, T1, S2, I2, SP2, TP2> Mapping<S1, S2> copyPlain(Automaton<S1, I1, T1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, ?, SP2, TP2> out, Mapping<? super S1, ? extends SP2> spMapping, Mapping<? super T1, ? extends TP2> tpMapping) {
        return AutomatonCopy.copyPlain(in, inputs, out, Mappings.identity(), spMapping, tpMapping);
    }

    public static <S1, I1, T1, SP1, TP1, S2, I2, SP2, TP2> Mapping<S1, S2> copyUniversalPlain(UniversalAutomaton<S1, I1, T1, SP1, TP1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, ?, SP2, TP2> out, Mapping<? super I1, ? extends I2> inputsMapping, Mapping<? super SP1, ? extends SP2> spConversion, Mapping<? super TP1, ? extends TP2> tpConversion) {
        Mapping spMapping = Mappings.compose(TS.stateProperties(in), spConversion);
        Mapping tpMapping = Mappings.compose(TS.transitionProperties(in), tpConversion);
        return AutomatonCopy.copyPlain(in, inputs, out, inputsMapping, spMapping, tpMapping);
    }

    public static <S1, I1, SP1, TP1, S2, SP2, TP2> Mapping<S1, S2> copyUniversalPlain(UniversalAutomaton<S1, I1, ?, SP1, TP1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, ? super I1, ?, SP2, TP2> out, Mapping<? super SP1, ? extends SP2> spConversion, Mapping<? super TP1, ? extends TP2> tpConversion) {
        return AutomatonCopy.copyUniversalPlain(in, inputs, out, Mappings.identity(), spConversion, tpConversion);
    }

    public static <S1, I1, T1, SP1, TP1, S2, I2> Mapping<S1, S2> copyUniversalPlain(UniversalAutomaton<S1, I1, T1, SP1, TP1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, ?, ? super SP1, ? super TP1> out, Mapping<? super I1, ? extends I2> inputsMapping) {
        return AutomatonCopy.copyPlain(in, inputs, out, inputsMapping, TS.stateProperties(in), TS.transitionProperties(in));
    }

    public static <S1, I1, T1, SP1, TP1, S2> Mapping<S1, S2> copyUniversalPlain(UniversalAutomaton<S1, I1, T1, SP1, TP1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, ? super I1, ?, ? super SP1, ? super TP1> out) {
        return AutomatonCopy.copyPlain(in, inputs, out, Mappings.identity(), TS.stateProperties(in), TS.transitionProperties(in));
    }

    public static <S1, I1, T1, S2, I2, T2, SP2, TP2> Mapping<S1, S2> copyTraversal(TraversalOrder order, int limit, TransitionSystem<S1, I1, T1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, T2, SP2, TP2> out, Mapping<? super I1, ? extends I2> inputsMapping, Mapping<? super S1, ? extends SP2> spMapping, Mapping<? super T1, ? extends TP2> tpMapping) {
        TraversalAutomatonCopy<S1, I1, T1, S2, I2, T2, SP2, TP2> copy = new TraversalAutomatonCopy<S1, I1, T1, S2, I2, T2, SP2, TP2>(order, limit, in, inputs, out, inputsMapping, spMapping, tpMapping);
        copy.doCopy();
        return copy.stateMapping;
    }

    public static <S1, I1 extends I2, T1, S2, I2, SP2, TP2> Mapping<S1, S2> copyDfs(TransitionSystem<S1, I1, T1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, ?, SP2, TP2> out, Mapping<? super S1, ? extends SP2> spMapping, Mapping<? super T1, ? extends TP2> tpMapping) {
        return AutomatonCopy.copyTraversal(TraversalOrder.DEPTH_FIRST, -1, in, inputs, out, Mappings.identity(), spMapping, tpMapping);
    }

    public static <S1, I1, T1, SP1, TP1, S2, I2, SP2, TP2> Mapping<S1, S2> copyUniversalDfs(UniversalTransitionSystem<S1, I1, T1, SP1, TP1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, ?, SP2, TP2> out, Mapping<? super I1, ? extends I2> inputsMapping, Mapping<? super SP1, ? extends SP2> spConversion, Mapping<? super TP1, ? extends TP2> tpConversion) {
        Mapping spMapping = Mappings.compose(TS.stateProperties(in), spConversion);
        Mapping tpMapping = Mappings.compose(TS.transitionProperties(in), tpConversion);
        return AutomatonCopy.copyTraversal(TraversalOrder.DEPTH_FIRST, -1, in, inputs, out, inputsMapping, spMapping, tpMapping);
    }

    public static <S1, I1, SP1, TP1, S2, SP2, TP2> Mapping<S1, S2> copyUniversalDfs(UniversalTransitionSystem<S1, I1, ?, SP1, TP1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, ? super I1, ?, SP2, TP2> out, Mapping<? super SP1, ? extends SP2> spConversion, Mapping<? super TP1, ? extends TP2> tpConversion) {
        return AutomatonCopy.copyUniversalDfs(in, inputs, out, Mappings.identity(), spConversion, tpConversion);
    }

    public static <S1, I1, T1, SP1, TP1, S2, I2> Mapping<S1, S2> copyUniversalDfs(UniversalTransitionSystem<S1, I1, T1, SP1, TP1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, ?, ? super SP1, ? super TP1> out, Mapping<? super I1, ? extends I2> inputsMapping) {
        return AutomatonCopy.copyTraversal(TraversalOrder.DEPTH_FIRST, -1, in, inputs, out, inputsMapping, TS.stateProperties(in), TS.transitionProperties(in));
    }

    public static <S1, I1, T1, SP1, TP1, S2> Mapping<S1, S2> copyUniversalDfs(UniversalTransitionSystem<S1, I1, T1, SP1, TP1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, ? super I1, ?, ? super SP1, ? super TP1> out) {
        return AutomatonCopy.copyTraversal(TraversalOrder.DEPTH_FIRST, -1, in, inputs, out, Mappings.identity(), TS.stateProperties(in), TS.transitionProperties(in));
    }

    private AutomatonCopy() {
    }
}

