/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.copy;

import java.util.ArrayList;
import java.util.Collection;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.util.automata.copy.AbstractAutomatonCopy;

final class PlainAutomatonCopy<S1, I1, T1, S2, I2, T2, SP2, TP2>
extends AbstractAutomatonCopy<S1, I1, T1, S2, I2, T2, SP2, TP2, Automaton<S1, I1, T1>> {
    public PlainAutomatonCopy(Automaton<S1, I1, T1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, T2, SP2, TP2> out, Mapping<? super I1, ? extends I2> inputsMapping, Mapping<? super S1, ? extends SP2> spMapping, Mapping<? super T1, ? extends TP2> tpMapping) {
        super(in, inputs, out, inputsMapping, spMapping, tpMapping);
    }

    @Override
    public void doCopy() {
        ArrayList outStates = new ArrayList(((Automaton)this.in).size());
        for (Object e : (Automaton)this.in) {
            Object s2 = this.copyState(e);
            outStates.add(new StateRec(e, s2));
        }
        for (StateRec stateRec : outStates) {
            Object s1 = stateRec.inState;
            Object s2 = stateRec.outState;
            for (Object i1 : this.inputs) {
                Object i2 = this.inputsMapping.get(i1);
                Collection transitions1 = ((Automaton)this.in).getTransitions(s1, i1);
                this.copyTransitions(s2, i2, transitions1);
            }
        }
        this.updateInitials();
    }

    private static class StateRec<S1, S2> {
        private final S1 inState;
        private final S2 outState;

        public StateRec(S1 inState, S2 outState) {
            this.inState = inState;
            this.outState = outState;
        }
    }
}

