/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.equivalence;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.util.automata.Automata;
import net.automatalib.words.Word;

public class CharacterizingSets {
    private static <S, I, T> List<Object> buildTrace(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, S state, Word<I> suffix) {
        Object sym;
        Object trans;
        ArrayList<Object> trace = new ArrayList<Object>(2 * suffix.length());
        Object curr = state;
        Iterator i$ = suffix.iterator();
        while (i$.hasNext() && (trans = automaton.getTransition(curr, sym = i$.next())) != null) {
            Object prop = automaton.getTransitionProperty(trans);
            trace.add(prop);
            curr = automaton.getSuccessor(trans);
            prop = automaton.getStateProperty(curr);
            trace.add(prop);
        }
        return trace;
    }

    private static <S, I, T> boolean checkTrace(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, S state, Word<I> suffix, List<Object> trace) {
        Iterator<Object> it = trace.iterator();
        Object curr = state;
        for (Object sym : suffix) {
            Object trans = automaton.getTransition(curr, sym);
            if (!it.hasNext()) {
                return trans == null;
            }
            Object prop = automaton.getTransitionProperty(trans);
            if (!Objects.equals(prop, it.next())) {
                return false;
            }
            curr = automaton.getSuccessor(trans);
            prop = automaton.getStateProperty(curr);
            if (Objects.equals(prop, it.next())) continue;
            return false;
        }
        return true;
    }

    private static <S, I, T> void cluster(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, Word<I> suffix, Iterator<S> stateIt, Map<List<Object>, List<S>> bucketMap) {
        while (stateIt.hasNext()) {
            S state = stateIt.next();
            List<Object> trace = CharacterizingSets.buildTrace(automaton, state, suffix);
            List<S> bucket = bucketMap.get(trace);
            if (bucket == null) {
                bucket = new ArrayList<S>();
                bucketMap.put(trace, bucket);
            }
            bucket.add(state);
        }
    }

    public static <S, I, T> void findCharacterizingSet(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, Collection<? extends I> inputs, S state, Collection<? super Word<I>> result) {
        Object prop = automaton.getStateProperty(state);
        ArrayList currentBlock = new ArrayList();
        boolean multipleStateProps = false;
        for (Object s : automaton) {
            if (Objects.equals(s, state)) continue;
            Object sProp = automaton.getStateProperty(s);
            if (!Objects.equals(sProp, prop)) {
                multipleStateProps = true;
                continue;
            }
            currentBlock.add(s);
        }
        if (multipleStateProps) {
            result.add(Word.epsilon());
        }
        while (!currentBlock.isEmpty()) {
            ArrayList nextBlock = new ArrayList();
            Iterator it = currentBlock.iterator();
            Word<? extends I> suffix = null;
            while (it.hasNext() && suffix == null) {
                Object s = it.next();
                suffix = Automata.findSeparatingWord(automaton, state, s, inputs);
            }
            if (suffix == null) {
                return;
            }
            result.add(suffix);
            List<Object> trace = CharacterizingSets.buildTrace(automaton, state, suffix);
            while (it.hasNext()) {
                Object s = it.next();
                if (!CharacterizingSets.checkTrace(automaton, s, suffix, trace)) continue;
                nextBlock.add(s);
            }
            currentBlock = nextBlock;
        }
    }

    public static <S, I, T> void findCharacterizingSet(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, Collection<? extends I> inputs, Collection<? super Word<I>> result) {
        List currBlock;
        HashMap initBlockMap = new HashMap();
        ArrayDeque<ArrayList<Object>> blocks = new ArrayDeque<ArrayList<Object>>();
        for (Object state : automaton) {
            Object prop = automaton.getStateProperty(state);
            ArrayList initBlock = (ArrayList)initBlockMap.get(prop);
            if (initBlock == null) {
                initBlock = new ArrayList();
                blocks.offer(initBlock);
                initBlockMap.put(prop, initBlock);
            }
            initBlock.add(state);
        }
        if (blocks.size() > 1) {
            result.add(Word.epsilon());
        }
        while ((currBlock = (List)blocks.poll()) != null) {
            Iterator it = currBlock.iterator();
            Object ref = it.next();
            Word<? extends I> suffix = null;
            S state = null;
            while (it.hasNext() && suffix == null) {
                state = (S)it.next();
                suffix = Automata.findSeparatingWord(automaton, ref, state, inputs);
            }
            if (suffix == null) continue;
            result.add(suffix);
            int otherBlocks = blocks.size();
            HashMap<List<Object>, List<S>> buckets = new HashMap<List<Object>, List<S>>();
            ArrayList firstBucket = new ArrayList();
            ArrayList<S> secondBucket = new ArrayList<S>();
            firstBucket.add(ref);
            buckets.put(CharacterizingSets.buildTrace(automaton, ref, suffix), firstBucket);
            secondBucket.add(state);
            buckets.put(CharacterizingSets.buildTrace(automaton, state, suffix), secondBucket);
            CharacterizingSets.cluster(automaton, suffix, it, buckets);
            blocks.addAll(buckets.values());
            while (otherBlocks-- > 0) {
                List block = (List)blocks.poll();
                buckets.clear();
                CharacterizingSets.cluster(automaton, suffix, block.iterator(), buckets);
                blocks.addAll(buckets.values());
            }
        }
    }
}

