/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.equivalence;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.commons.util.UnionFind;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class NearLinearEquivalenceTest<I> {
    private final UniversalDeterministicAutomaton<?, I, ?, ?, ?> target;

    public NearLinearEquivalenceTest(UniversalDeterministicAutomaton<?, I, ?, ?, ?> target) {
        this.target = target;
    }

    public Word<I> findSeparatingWord(UniversalDeterministicAutomaton<?, I, ?, ?, ?> other, Collection<? extends I> inputs) {
        return NearLinearEquivalenceTest.findSeparatingWord(this.target, other, inputs);
    }

    public static <S, S2, I, T, T2> Word<I> findSeparatingWord(UniversalDeterministicAutomaton<S, I, T, ?, ?> target, UniversalDeterministicAutomaton<S2, I, T2, ?, ?> other, Collection<? extends I> inputs) {
        Record current;
        Object sprop2;
        int targetStates = target.size();
        UnionFind uf = new UnionFind(targetStates + other.size());
        Object init1 = target.getInitialState();
        Object init2 = other.getInitialState();
        Object sprop1 = target.getStateProperty(init1);
        if (!Objects.equals(sprop1, sprop2 = other.getStateProperty(init2))) {
            return Word.epsilon();
        }
        StateIDs targetStateIds = target.stateIDs();
        StateIDs otherStateIds = other.stateIDs();
        int id1 = targetStateIds.getStateId(init1);
        int id2 = otherStateIds.getStateId(init2) + targetStates;
        uf.link(id1, id2);
        ArrayDeque<Record<Object, Object, I>> queue = new ArrayDeque<Record<Object, Object, I>>();
        queue.offer(new Record(init1, init2));
        Object lastSym = null;
        block0: while ((current = (Record)queue.poll()) != null) {
            Object state1 = current.state1;
            Object state2 = current.state2;
            for (I sym : inputs) {
                int r2;
                Object tprop2;
                Object trans1 = target.getTransition(state1, sym);
                Object trans2 = other.getTransition(state2, sym);
                if (trans1 == null) {
                    if (trans2 == null) continue;
                    lastSym = sym;
                    break block0;
                }
                if (trans2 == null) {
                    lastSym = sym;
                    break block0;
                }
                Object tprop1 = target.getTransitionProperty(trans1);
                if (!Objects.equals(tprop1, tprop2 = other.getTransitionProperty(trans2))) {
                    lastSym = sym;
                    break block0;
                }
                Object succ1 = target.getSuccessor(trans1);
                Object succ2 = other.getSuccessor(trans2);
                id1 = targetStateIds.getStateId(succ1);
                id2 = otherStateIds.getStateId(succ2) + targetStates;
                int r1 = uf.find(id1);
                if (r1 == (r2 = uf.find(id2))) continue;
                sprop1 = target.getStateProperty(succ1);
                if (!Objects.equals(sprop1, sprop2 = other.getStateProperty(succ2))) {
                    lastSym = sym;
                    break block0;
                }
                uf.link(r1, r2);
                queue.offer(new Record<Object, Object, I>(succ1, succ2, sym, current));
            }
        }
        if (current == null) {
            return null;
        }
        int ceLength = current.depth;
        if (lastSym != null) {
            ++ceLength;
        }
        WordBuilder wb = new WordBuilder(null, ceLength);
        int index = ceLength;
        if (lastSym != null) {
            wb.setSymbol(--index, lastSym);
        }
        while (current.reachedFrom != null) {
            wb.setSymbol(--index, current.reachedBy);
            current = current.reachedFrom;
        }
        return wb.toWord();
    }

    public static <S, I, T> Word<I> findSeparatingWord(UniversalDeterministicAutomaton<S, I, T, ?, ?> target, S init1, S init2, Collection<? extends I> inputs) {
        Record current;
        Object sprop2;
        UnionFind uf = new UnionFind(target.size());
        Object sprop1 = target.getStateProperty(init1);
        if (!Objects.equals(sprop1, sprop2 = target.getStateProperty(init2))) {
            return Word.epsilon();
        }
        StateIDs stateIds = target.stateIDs();
        int id1 = stateIds.getStateId(init1);
        int id2 = stateIds.getStateId(init2);
        uf.link(id1, id2);
        ArrayDeque queue = new ArrayDeque();
        queue.offer(new Record(init1, init2));
        Object lastSym = null;
        block0: while ((current = (Record)queue.poll()) != null) {
            Object state1 = current.state1;
            Object state2 = current.state2;
            for (I sym : inputs) {
                int r2;
                Object tprop2;
                Object trans1 = target.getTransition(state1, sym);
                Object trans2 = target.getTransition(state2, sym);
                if (trans1 == null) {
                    if (trans2 == null) continue;
                    lastSym = sym;
                    break block0;
                }
                if (trans2 == null) {
                    lastSym = sym;
                    break block0;
                }
                Object tprop1 = target.getTransitionProperty(trans1);
                if (!Objects.equals(tprop1, tprop2 = target.getTransitionProperty(trans2))) {
                    lastSym = sym;
                    break block0;
                }
                Object succ1 = target.getSuccessor(trans1);
                Object succ2 = target.getSuccessor(trans2);
                id1 = stateIds.getStateId(succ1);
                id2 = stateIds.getStateId(succ2);
                int r1 = uf.find(id1);
                if (r1 == (r2 = uf.find(id2))) continue;
                sprop1 = target.getStateProperty(succ1);
                if (!Objects.equals(sprop1, sprop2 = target.getStateProperty(succ2))) {
                    lastSym = sym;
                    break block0;
                }
                uf.link(r1, r2);
                queue.offer(new Record<Object, Object, I>(succ1, succ2, sym, current));
            }
        }
        if (current == null) {
            return null;
        }
        int ceLength = current.depth;
        if (lastSym != null) {
            ++ceLength;
        }
        WordBuilder wb = new WordBuilder(null, ceLength);
        int index = ceLength;
        if (lastSym != null) {
            wb.setSymbol(--index, lastSym);
        }
        while (current.reachedFrom != null) {
            wb.setSymbol(--index, current.reachedBy);
            current = current.reachedFrom;
        }
        return wb.toWord();
    }

    private static final class Record<S, S2, I> {
        private final S state1;
        private final S2 state2;
        private final I reachedBy;
        private final Record<S, S2, I> reachedFrom;
        private final int depth;

        public Record(S state1, S2 state2) {
            this(state1, state2, null, null);
        }

        public Record(S state1, S2 state2, I reachedBy, Record<S, S2, I> reachedFrom) {
            this.state1 = state1;
            this.state2 = state2;
            this.reachedBy = reachedBy;
            this.reachedFrom = reachedFrom;
            this.depth = reachedFrom != null ? reachedFrom.depth + 1 : 0;
        }
    }
}

