/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.fsa;

import java.util.Collection;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.MutableDFA;
import net.automatalib.automata.fsa.impl.FastDFA;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.commons.util.mappings.Mappings;
import net.automatalib.util.automata.copy.AutomatonCopy;
import net.automatalib.util.ts.acceptors.AcceptanceCombiner;
import net.automatalib.util.ts.acceptors.Acceptors;
import net.automatalib.util.ts.acceptors.DetAcceptorComposition;
import net.automatalib.words.Alphabet;

public abstract class DFAs {
    private static final Mapping<Boolean, Boolean> NEGATE = new Mapping<Boolean, Boolean>(){

        public Boolean get(Boolean elem) {
            return elem == false;
        }
    };

    public static <I, S, A extends MutableDFA<S, I>> A combine(DFA<?, I> dfa1, DFA<?, I> dfa2, Collection<? extends I> inputs, A out, AcceptanceCombiner combiner) {
        DetAcceptorComposition acc = Acceptors.combine(dfa1, dfa2, combiner);
        AutomatonCopy.copyUniversalDfs(acc, inputs, out, Mappings.identity());
        return out;
    }

    public static <I> FastDFA<I> combine(DFA<?, I> dfa1, DFA<?, I> dfa2, Alphabet<I> inputAlphabet, AcceptanceCombiner combiner) {
        return DFAs.combine(dfa1, dfa2, inputAlphabet, new FastDFA(inputAlphabet), combiner);
    }

    public static <I, S, A extends MutableDFA<S, I>> A and(DFA<?, I> dfa1, DFA<?, I> dfa2, Collection<? extends I> inputs, A out) {
        return DFAs.combine(dfa1, dfa2, inputs, out, AcceptanceCombiner.AND);
    }

    public static <I> FastDFA<I> and(DFA<?, I> dfa1, DFA<?, I> dfa2, Alphabet<I> inputAlphabet) {
        return DFAs.and(dfa1, dfa2, inputAlphabet, new FastDFA(inputAlphabet));
    }

    public static <I, S, A extends MutableDFA<S, I>> A or(DFA<?, I> dfa1, DFA<?, I> dfa2, Collection<? extends I> inputs, A out) {
        return DFAs.combine(dfa1, dfa2, inputs, out, AcceptanceCombiner.OR);
    }

    public static <I> FastDFA<I> or(DFA<?, I> dfa1, DFA<?, I> dfa2, Alphabet<I> inputAlphabet) {
        return DFAs.or(dfa1, dfa2, inputAlphabet, new FastDFA(inputAlphabet));
    }

    public static <I, S, A extends MutableDFA<S, I>> A xor(DFA<?, I> dfa1, DFA<?, I> dfa2, Collection<? extends I> inputs, A out) {
        return DFAs.combine(dfa1, dfa2, inputs, out, AcceptanceCombiner.XOR);
    }

    public static <I> FastDFA<I> xor(DFA<?, I> dfa1, DFA<?, I> dfa2, Alphabet<I> inputAlphabet) {
        return DFAs.xor(dfa1, dfa2, inputAlphabet, new FastDFA(inputAlphabet));
    }

    public static <I, S, A extends MutableDFA<S, I>> A equiv(DFA<?, I> dfa1, DFA<?, I> dfa2, Collection<? extends I> inputs, A out) {
        return DFAs.combine(dfa1, dfa2, inputs, out, AcceptanceCombiner.EQUIV);
    }

    public static <I> FastDFA<I> equiv(DFA<?, I> dfa1, DFA<?, I> dfa2, Alphabet<I> inputAlphabet) {
        return DFAs.equiv(dfa1, dfa2, inputAlphabet, new FastDFA(inputAlphabet));
    }

    public static <I, S, A extends MutableDFA<S, I>> A impl(DFA<?, I> dfa1, DFA<?, I> dfa2, Collection<? extends I> inputs, A out) {
        return DFAs.combine(dfa1, dfa2, inputs, out, AcceptanceCombiner.IMPL);
    }

    public static <I> FastDFA<I> impl(DFA<?, I> dfa1, DFA<?, I> dfa2, Alphabet<I> inputAlphabet) {
        return DFAs.impl(dfa1, dfa2, inputAlphabet, new FastDFA(inputAlphabet));
    }

    public static <I, S, A extends MutableDFA<S, I>> A complement(DFA<?, I> dfa, Collection<? extends I> inputs, A out) {
        AutomatonCopy.copyUniversalDfs(dfa, inputs, out, NEGATE, Mappings.nullMapping());
        return out;
    }

    public static <I> FastDFA<I> complement(DFA<?, I> dfa, Alphabet<I> inputAlphabet) {
        return DFAs.complement(dfa, inputAlphabet, new FastDFA(inputAlphabet));
    }
}

