/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.random;

import java.util.Collection;
import java.util.Random;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.util.automata.Automata;
import net.automatalib.util.automata.random.RandomDeterministicAutomatonGenerator;

public abstract class RandomAutomata {
    public static <S, I, T, SP, TP, A extends MutableDeterministic<S, I, T, SP, TP>> A randomDeterministic(Random rand, int numStates, Collection<? extends I> inputs, Collection<? extends SP> stateProps, Collection<? extends TP> transProps, A out) {
        return RandomAutomata.randomDeterministic(rand, numStates, inputs, stateProps, transProps, out, true);
    }

    public static <S, I, T, SP, TP, A extends MutableDeterministic<S, I, T, SP, TP>> A randomDeterministic(Random rand, int numStates, Collection<? extends I> inputs, Collection<? extends SP> stateProps, Collection<? extends TP> transProps, A out, boolean minimize) {
        RandomDeterministicAutomatonGenerator gen = new RandomDeterministicAutomatonGenerator(rand, inputs, stateProps, transProps, out);
        gen.addStates(numStates);
        gen.addTransitions();
        gen.chooseInitial();
        if (minimize) {
            Automata.invasiveMinimize(out, inputs);
        }
        return out;
    }

    private RandomAutomata() {
    }
}

