/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.automatalib.commons.util.Holder;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.util.graphs.Path;
import net.automatalib.util.graphs.traversal.DefaultGraphTraversalVisitor;
import net.automatalib.util.graphs.traversal.GraphTraversalAction;

final class FindShortestPathVisitor<N, E>
extends DefaultGraphTraversalVisitor<N, E, Void> {
    private final MutableMapping<N, Pred<N, E>> predMapping;
    private final Collection<? extends N> targetNodes;
    private N foundTarget;

    public FindShortestPathVisitor(IndefiniteGraph<N, E> graph, Collection<? extends N> targetNodes) {
        this.targetNodes = targetNodes;
        this.predMapping = graph.createStaticNodeMapping();
    }

    @Override
    public GraphTraversalAction processInitial(N initialNode, Holder<Void> outData) {
        this.predMapping.put(initialNode, new Pred<Object, Object>(null, null));
        if (this.targetNodes.contains(initialNode)) {
            this.foundTarget = initialNode;
            return GraphTraversalAction.ABORT_TRAVERSAL;
        }
        return GraphTraversalAction.EXPLORE;
    }

    @Override
    public GraphTraversalAction processEdge(N srcNode, Void srcData, E edge, N tgtNode, Holder<Void> outData) {
        if (this.targetNodes.contains(tgtNode)) {
            Pred<N, E> pred = new Pred<N, E>(srcNode, edge);
            this.predMapping.put(tgtNode, pred);
            this.foundTarget = tgtNode;
            return GraphTraversalAction.ABORT_TRAVERSAL;
        }
        Pred<N, E> pred = (Pred<N, E>)this.predMapping.get(tgtNode);
        if (pred != null) {
            return GraphTraversalAction.IGNORE;
        }
        pred = new Pred<N, E>(srcNode, edge);
        this.predMapping.put(tgtNode, pred);
        return GraphTraversalAction.EXPLORE;
    }

    public boolean wasSuccessful() {
        return this.foundTarget != null;
    }

    public Path.PathData<N, E> getTargetPath() {
        ArrayList edges = new ArrayList();
        N currNode = this.foundTarget;
        Pred pred = (Pred)this.predMapping.get(currNode);
        while (pred != null && pred.edge != null) {
            edges.add(pred.edge);
            currNode = pred.node;
            pred = (Pred)this.predMapping.get(currNode);
        }
        Collections.reverse(edges);
        return new Path.PathData(currNode, edges);
    }

    private static final class Pred<N, E> {
        public final N node;
        public final E edge;

        public Pred(N node, E edge) {
            this.node = node;
            this.edge = edge;
        }
    }
}

