/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.BidirectionalGraph;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.graphs.UniversalIndefiniteGraph;
import net.automatalib.util.graphs.FindShortestPathVisitor;
import net.automatalib.util.graphs.InEdgesMapping;
import net.automatalib.util.graphs.Path;
import net.automatalib.util.graphs.traversal.GraphTraversal;

public abstract class Graphs {
    public static <N, E> Mapping<N, Collection<E>> incomingEdges(Graph<N, E> graph) {
        if (graph instanceof BidirectionalGraph) {
            return new InEdgesMapping((BidirectionalGraph)graph);
        }
        MutableMapping inEdgesMapping = graph.createStaticNodeMapping();
        for (Object node : graph) {
            Collection outEdges = graph.getOutgoingEdges(node);
            if (outEdges == null) continue;
            for (Object e : outEdges) {
                Object tgt = graph.getTarget(e);
                ArrayList inEdges = (ArrayList)inEdgesMapping.get(tgt);
                if (inEdges == null) {
                    inEdges = new ArrayList();
                    inEdgesMapping.put(tgt, inEdges);
                }
                inEdges.add(e);
            }
        }
        return inEdgesMapping;
    }

    public static <N, E> Path<N, E> findShortestPath(IndefiniteGraph<N, E> graph, int limit, N start, Collection<? extends N> targets) {
        FindShortestPathVisitor<N, E> vis = new FindShortestPathVisitor<N, E>(graph, targets);
        GraphTraversal.breadthFirst(graph, limit, Collections.singleton(start), vis);
        if (!vis.wasSuccessful()) {
            return null;
        }
        return vis.getTargetPath().toPath(graph);
    }

    public static <N, NP> Mapping<N, NP> nodeProperties(final UniversalIndefiniteGraph<N, ?, NP, ?> graph) {
        return new Mapping<N, NP>(){

            public NP get(N elem) {
                return graph.getNodeProperty(elem);
            }
        };
    }

    public static <E, EP> Mapping<E, EP> edgeProperties(final UniversalIndefiniteGraph<?, E, ?, EP> graph) {
        return new Mapping<E, EP>(){

            public EP get(E elem) {
                return graph.getEdgeProperty(elem);
            }
        };
    }

    private Graphs() {
    }
}

