/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.traversal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.util.graphs.traversal.SimpleDFRecord;
import net.automatalib.util.traversal.VisitedState;

final class DepthFirstIterator<N, E>
implements Iterator<N> {
    private final MutableMapping<N, VisitedState> visited;
    private final Deque<SimpleDFRecord<N, E>> dfsStack = new ArrayDeque<SimpleDFRecord<N, E>>();
    private final IndefiniteGraph<N, E> graph;

    public DepthFirstIterator(IndefiniteGraph<N, E> graph, Collection<? extends N> start) {
        this.graph = graph;
        this.visited = graph.createStaticNodeMapping();
        for (N startNode : start) {
            this.dfsStack.push(new SimpleDFRecord(startNode));
        }
    }

    @Override
    public boolean hasNext() {
        return !this.dfsStack.isEmpty();
    }

    @Override
    public N next() {
        Object result;
        SimpleDFRecord<N, E> rec = this.dfsStack.peek();
        if (rec == null) {
            throw new NoSuchElementException();
        }
        if (rec.start(this.graph)) {
            result = rec.node;
            this.visited.put(result, (Object)VisitedState.VISITED);
        } else {
            E edge = rec.nextEdge();
            result = this.graph.getTarget(edge);
            if (this.visited.get(result) != VisitedState.VISITED) {
                this.dfsStack.push(new SimpleDFRecord(result));
            }
        }
        this.cleanup();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void cleanup() {
        SimpleDFRecord<N, E> rec;
        while ((rec = this.dfsStack.peek()) != null) {
            if (!rec.wasStarted()) {
                if (this.visited.get(rec.node) != VisitedState.VISITED) {
                    return;
                }
            } else {
                while (rec.hasNextEdge()) {
                    E edge = rec.nextEdge();
                    Object tgt = this.graph.getTarget(edge);
                    if (this.visited.get(tgt) == VisitedState.VISITED) continue;
                    rec.retract(edge);
                    return;
                }
            }
            this.dfsStack.pop();
        }
    }
}

